/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.po.hbm.TbSysBeanHelp;
import com.netsteadfast.greenstep.po.hbm.TbSysBeanHelpExpr;
import com.netsteadfast.greenstep.po.hbm.TbSysBeanHelpExprMap;
import com.netsteadfast.greenstep.po.hbm.TbSysExpression;
import com.netsteadfast.greenstep.service.ISysBeanHelpExprMapService;
import com.netsteadfast.greenstep.service.ISysBeanHelpExprService;
import com.netsteadfast.greenstep.service.ISysBeanHelpService;
import com.netsteadfast.greenstep.service.ISysExpressionService;
import com.netsteadfast.greenstep.util.ScriptExpressionUtils;
import com.netsteadfast.greenstep.vo.SysBeanHelpExprMapVO;
import com.netsteadfast.greenstep.vo.SysBeanHelpExprVO;
import com.netsteadfast.greenstep.vo.SysBeanHelpVO;
import com.netsteadfast.greenstep.vo.SysExpressionVO;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;

public class ServiceScriptExpressionUtils {
    private static ISysBeanHelpService<SysBeanHelpVO, TbSysBeanHelp, String> sysBeanHelpService = (ISysBeanHelpService)AppContext.getBean("core.service.SysBeanHelpService");
    private static ISysBeanHelpExprService<SysBeanHelpExprVO, TbSysBeanHelpExpr, String> sysBeanHelpExprService = (ISysBeanHelpExprService)AppContext.getBean("core.service.SysBeanHelpExprService");
    private static ISysBeanHelpExprMapService<SysBeanHelpExprMapVO, TbSysBeanHelpExprMap, String> sysBeanHelpExprMapService = (ISysBeanHelpExprMapService)AppContext.getBean("core.service.SysBeanHelpExprMapService");
    private static ISysExpressionService<SysExpressionVO, TbSysExpression, String> sysExpressionService = (ISysExpressionService)AppContext.getBean("core.service.SysExpressionService");

    public static boolean needProcess(String beanId, String methodName, String system) throws ServiceException, Exception {
        boolean f = false;
        SysBeanHelpVO beanHelp = new SysBeanHelpVO();
        beanHelp.setBeanId(beanId);
        beanHelp.setMethod(methodName);
        beanHelp.setSystem(system);
        if (sysBeanHelpService.countByUK(beanHelp) > 0) {
            f = true;
        }
        beanHelp = null;
        return f;
    }

    public static void processBefore(String beanId, Method method, String system, ProceedingJoinPoint pjp) throws ServiceException, Exception {
        ServiceScriptExpressionUtils.process("BEFORE", beanId, method, system, null, pjp);
    }

    public static void processAfter(String beanId, Method method, String system, Object resultObj, ProceedingJoinPoint pjp) throws ServiceException, Exception {
        ServiceScriptExpressionUtils.process("AFTER", beanId, method, system, resultObj, pjp);
    }

    private static SysBeanHelpVO loadSysBeanHelperData(String beanId, String methodName, String system) throws ServiceException, Exception {
        SysBeanHelpVO beanHelp = new SysBeanHelpVO();
        beanHelp.setBeanId(beanId);
        beanHelp.setMethod(methodName);
        beanHelp.setSystem(system);
        DefaultResult<SysBeanHelpVO> result = sysBeanHelpService.findByUK(beanHelp);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        beanHelp = result.getValue();
        return beanHelp;
    }

    private static List<TbSysBeanHelpExpr> loadSysBeanHelpExprsData(SysBeanHelpVO beanHelp) throws ServiceException, Exception {
        List<TbSysBeanHelpExpr> exprs = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> orderParams = new HashMap<String, String>();
        params.put("helpOid", beanHelp.getOid());
        orderParams.put("exprSeq", "ASC");
        exprs = sysBeanHelpExprService.findListByParams(params, null, orderParams);
        if (exprs == null) {
            exprs = new ArrayList();
        }
        params.clear();
        orderParams.clear();
        params = null;
        orderParams = null;
        return exprs;
    }

    private static List<TbSysBeanHelpExprMap> loadSysBeanHelpExprMapsData(TbSysBeanHelpExpr beanHelpExpr) throws ServiceException, Exception {
        List<TbSysBeanHelpExprMap> exprMaps = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("helpExprOid", beanHelpExpr.getOid());
        exprMaps = sysBeanHelpExprMapService.findListByParams(params);
        if (exprMaps == null) {
            exprMaps = new ArrayList();
        }
        params.clear();
        params = null;
        return exprMaps;
    }

    private static Map<String, Object> getParameters(TbSysBeanHelpExpr beanHelpExpr, List<TbSysBeanHelpExprMap> beanHelpExprMaps, Object resultObj, ProceedingJoinPoint pjp) {
        Object[] args = pjp.getArgs();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        for (TbSysBeanHelpExprMap map : beanHelpExprMaps) {
            Object value = null;
            if ("Y".equals(map.getMethodResultFlag())) {
                value = resultObj;
            } else {
                int i = 0;
                while (args != null && i < args.length) {
                    if (args[i] != null && args[i].getClass() != null && args[i].getClass().getName().equals(map.getMethodParamClass()) && map.getMethodParamIndex() == i) {
                        value = args[i];
                    }
                    ++i;
                }
            }
            dataMap.put(map.getVarName(), value);
        }
        return dataMap;
    }

    private static void process(String runType, String beanId, Method method, String system, Object resultObj, ProceedingJoinPoint pjp) throws ServiceException, Exception {
        SysBeanHelpVO beanHelp = ServiceScriptExpressionUtils.loadSysBeanHelperData(beanId, method.getName(), system);
        if (!"Y".equals(beanHelp.getEnableFlag())) {
            return;
        }
        List<TbSysBeanHelpExpr> beanHelpExprs = ServiceScriptExpressionUtils.loadSysBeanHelpExprsData(beanHelp);
        if (beanHelpExprs == null || beanHelpExprs.size() < 1) {
            return;
        }
        for (TbSysBeanHelpExpr helpExpr : beanHelpExprs) {
            SysExpressionVO expression = new SysExpressionVO();
            expression.setExprId(helpExpr.getExprId());
            DefaultResult<SysExpressionVO> eResult = sysExpressionService.findByUK(expression);
            if (eResult.getValue() == null) continue;
            expression = eResult.getValue();
            List<TbSysBeanHelpExprMap> exprMaps = ServiceScriptExpressionUtils.loadSysBeanHelpExprMapsData(helpExpr);
            ScriptExpressionUtils.execute(expression.getType(), expression.getContent(), null, ServiceScriptExpressionUtils.getParameters(helpExpr, exprMaps, resultObj, pjp));
        }
    }
}

