/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.util.FSUtils;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.olap4j.CellSet;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;

public class OlapUtils {
    public static final String DEFAULT_DRIVER_NAME = "mondrian.olap4j.MondrianOlap4jDriver";

    public static OlapConnection getConnection(String driver, String url) throws ClassNotFoundException, SQLException, Exception {
        Class.forName(driver);
        Connection connection = DriverManager.getConnection(url);
        return connection.unwrap(OlapConnection.class);
    }

    public static OlapConnection getConnection(String url) throws ClassNotFoundException, SQLException, Exception {
        return OlapUtils.getConnection(DEFAULT_DRIVER_NAME, url);
    }

    public static CellSet getResultSet(OlapConnection connection, String mdx) throws OlapException, Exception {
        OlapStatement olapStatement = connection.createStatement();
        CellSet cellSet = olapStatement.executeOlapQuery(mdx);
        return cellSet;
    }

    public static void closeConnection(OlapConnection connection) throws Exception {
        if (connection == null) {
            return;
        }
        if (connection.isClosed()) {
            return;
        }
        connection.close();
    }

    public static void nullConnection(OlapConnection connection) throws Exception {
        OlapUtils.closeConnection(connection);
        connection = null;
    }

    public static void closeResultSet(CellSet cellSet) throws Exception {
        if (cellSet == null) {
            return;
        }
        if (cellSet.isClosed()) {
            return;
        }
        cellSet.close();
    }

    public static void nullResultSet(CellSet cellSet) throws Exception {
        OlapUtils.closeResultSet(cellSet);
        cellSet = null;
    }

    public static void testMondrianCatalog(String schemaContent) throws Exception {
        if (StringUtils.isBlank(schemaContent)) {
            throw new IllegalArgumentException("Mondrian Catalog is null.");
        }
        if (schemaContent.indexOf("<") == -1 || schemaContent.indexOf(">") == -1 || schemaContent.length() > 100000) {
            throw new IllegalArgumentException("not a Mondrian Catalog.");
        }
        XStream xStream = new XStream();
        xStream.registerConverter(new MapEntryConverter());
        xStream.alias("Schema", Map.class);
        Object resultObj = xStream.fromXML(schemaContent);
        System.out.println(resultObj);
    }

    public static File writeCatalogContentToFile(String catalogId, String catalogContent) throws IOException, Exception {
        if (StringUtils.isBlank(catalogContent)) {
            throw new IllegalArgumentException("null catalog.");
        }
        String fileFullPath = String.valueOf(Constants.getWorkTmpDir()) + "/catalog-" + catalogId + ".xml";
        if (!FSUtils.writeStr2(fileFullPath, catalogContent)) {
            throw new Exception("error, write catalog to file failure.");
        }
        return new File(fileFullPath);
    }

    public static String getMondrianUrl(String traditionJdbcUrl, String jdbcDrivers, String catalogFileFullPath) throws Exception {
        String url = "jdbc:mondrian:";
        url = String.valueOf(url) + "Jdbc='" + traditionJdbcUrl + "';";
        url = String.valueOf(url) + "Catalog='file://" + catalogFileFullPath + "';";
        url = String.valueOf(url) + "JdbcDrivers=" + jdbcDrivers + ";";
        return url;
    }

    public static class MapEntryConverter
    implements Converter {
        @Override
        public boolean canConvert(Class clazz) {
            return AbstractMap.class.isAssignableFrom(clazz);
        }

        @Override
        public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
            AbstractMap map = (AbstractMap)value;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry obj;
                Map.Entry entry = obj = iterator.next();
                writer.startNode(entry.getKey().toString());
                Object val = entry.getValue();
                if (val != null) {
                    writer.setValue(val.toString());
                }
                writer.endNode();
            }
        }

        @Override
        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            HashMap<String, String> map = new HashMap<String, String>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String key = reader.getNodeName();
                String value = reader.getValue();
                map.put(key, value);
                reader.moveUp();
            }
            return map;
        }
    }
}

