/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.model.MenuResultObj;
import com.netsteadfast.greenstep.po.hbm.TbSys;
import com.netsteadfast.greenstep.po.hbm.TbSysMenu;
import com.netsteadfast.greenstep.po.hbm.TbSysMultiName;
import com.netsteadfast.greenstep.po.hbm.TbSysProg;
import com.netsteadfast.greenstep.po.hbm.TbSysProgMultiName;
import com.netsteadfast.greenstep.po.hbm.TbSysTwitter;
import com.netsteadfast.greenstep.service.ISysMenuService;
import com.netsteadfast.greenstep.service.ISysMultiNameService;
import com.netsteadfast.greenstep.service.ISysProgMultiNameService;
import com.netsteadfast.greenstep.service.ISysProgService;
import com.netsteadfast.greenstep.service.ISysService;
import com.netsteadfast.greenstep.service.ISysTwitterService;
import com.netsteadfast.greenstep.util.IconUtils;
import com.netsteadfast.greenstep.util.LocaleLanguageUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.util.SystemSettingConfigureUtils;
import com.netsteadfast.greenstep.vo.SysMenuVO;
import com.netsteadfast.greenstep.vo.SysMultiNameVO;
import com.netsteadfast.greenstep.vo.SysProgMultiNameVO;
import com.netsteadfast.greenstep.vo.SysProgVO;
import com.netsteadfast.greenstep.vo.SysTwitterVO;
import com.netsteadfast.greenstep.vo.SysVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class MenuSupportUtils {
    private static final String MENU_ITEM_JAVASCRIPT = "javascript";
    private static final String MENU_ITEM_HTML = "html";
    private static final String MENU_ITEM_DIALOG = "dialog";
    private static ISysService<SysVO, TbSys, String> sysService = (ISysService)AppContext.getBean("core.service.SysService");
    private static ISysMenuService<SysMenuVO, TbSysMenu, String> sysMenuService = (ISysMenuService)AppContext.getBean("core.service.SysMenuService");
    private static ISysProgService<SysProgVO, TbSysProg, String> sysProgService = (ISysProgService)AppContext.getBean("core.service.SysProgService");
    private static ISysTwitterService<SysTwitterVO, TbSysTwitter, String> sysTwitterService = (ISysTwitterService)AppContext.getBean("core.service.SysTwitterService");
    private static ISysMultiNameService<SysMultiNameVO, TbSysMultiName, String> sysMultiNameService = (ISysMultiNameService)AppContext.getBean("core.service.SysMultiNameService");
    private static ISysProgMultiNameService<SysProgMultiNameVO, TbSysProgMultiName, String> sysProgMultiNameService = (ISysProgMultiNameService)AppContext.getBean("core.service.SysProgMultiNameService");

    public static ISysService<SysVO, TbSys, String> getSysService() {
        return sysService;
    }

    public static void setSysService(ISysService<SysVO, TbSys, String> sysService) {
        MenuSupportUtils.sysService = sysService;
    }

    public static ISysMenuService<SysMenuVO, TbSysMenu, String> getSysMenuService() {
        return sysMenuService;
    }

    public static void setSysMenuService(ISysMenuService<SysMenuVO, TbSysMenu, String> sysMenuService) {
        MenuSupportUtils.sysMenuService = sysMenuService;
    }

    public static TbSysProg loadSysProg(String progId) throws ServiceException, Exception {
        TbSysProg tbSysProg = new TbSysProg();
        tbSysProg.setProgId(progId);
        tbSysProg = sysProgService.findByEntityUK(tbSysProg);
        if (tbSysProg == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
        }
        return tbSysProg;
    }

    private static String getUrlPath(String url, String slash) {
        if (url.endsWith(slash)) {
            return url;
        }
        return String.valueOf(url) + slash;
    }

    public static String getUrl(String basePath, TbSys sys, TbSysProg sysProg, String jsessionId) throws Exception {
        String url = "";
        if ("Y".equals(sys.getIsLocal())) {
            url = String.valueOf(MenuSupportUtils.getUrlPath(basePath, "/")) + sysProg.getUrl() + (sysProg.getUrl().indexOf("?") > 0 || sysProg.getUrl().indexOf("&") > 0 ? "&" : "?") + "isDojoxContentPane" + "=" + "Y";
        } else {
            String head = "http://";
            if (basePath.startsWith("https")) {
                head = "https://";
            }
            url = String.valueOf(head) + MenuSupportUtils.getUrlPath(sys.getHost(), "/") + MenuSupportUtils.getUrlPath(sys.getContextPath(), "/") + sysProg.getUrl() + (sysProg.getUrl().indexOf("?") > 0 || sysProg.getUrl().indexOf("&") > 0 ? "&" : "?") + "isDojoxContentPane" + "=" + "Y";
        }
        if (sysProg.getUrl().indexOf("commomLoadForm.action") > -1) {
            url = String.valueOf(url) + "&prog_id=" + sysProg.getProgId();
        }
        if ("Y".equals(sysProg.getIsWindow())) {
            url = String.valueOf(url) + "&isIframeMode=Y";
        }
        return url;
    }

    protected static List<TbSysProg> loadSysProgData(String system) throws ServiceException, Exception {
        List<TbSysProg> progList = null;
        TbSys sys = new TbSys();
        sys.setSysId(system);
        if (sysService.countByEntityUK(sys) != 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> oderParams = new HashMap<String, String>();
        params.put("progSystem", system);
        oderParams.put("name", "asc");
        progList = sysProgService.findListByParams(params, null, oderParams);
        if (progList == null) {
            progList = new ArrayList<TbSysProg>();
        }
        return progList;
    }

    protected static List<SysMenuVO> loadSysMenuData(String system) throws ServiceException, Exception {
        DefaultResult<List<SysMenuVO>> result;
        List<SysMenuVO> menuList = null;
        TbSys sys = new TbSys();
        sys.setSysId(system);
        if (sysService.countByEntityUK(sys) != 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
        }
        Subject subject = SecurityUtils.getSubject();
        String account = (String)subject.getPrincipal();
        if (StringUtils.isBlank(account)) {
            throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
        }
        if (subject.hasRole("admin") || subject.hasRole("*")) {
            account = null;
        }
        if ((result = sysMenuService.findForMenuGenerator(system, account)).getValue() != null) {
            menuList = result.getValue();
        }
        if (menuList == null) {
            menuList = new ArrayList<SysMenuVO>();
        }
        return menuList;
    }

    protected static List<SysMenuVO> searchFolder(List<SysMenuVO> sysMenuList) throws Exception {
        ArrayList<SysMenuVO> folderList = new ArrayList<SysMenuVO>();
        for (SysMenuVO sysMenu : sysMenuList) {
            if (!"FOLDER".equals(sysMenu.getItemType()) || !"Y".equals(sysMenu.getEnableFlag())) continue;
            folderList.add(sysMenu);
        }
        return folderList;
    }

    protected static List<SysMenuVO> searchItem(String parentOid, List<SysMenuVO> sysMenuList) throws Exception {
        ArrayList<SysMenuVO> folderList = new ArrayList<SysMenuVO>();
        for (SysMenuVO sysMenu : sysMenuList) {
            if (!"ITEM".equals(sysMenu.getItemType()) || !parentOid.equals(sysMenu.getParentOid()) || !"Y".equals(sysMenu.getEnableFlag())) continue;
            folderList.add(sysMenu);
        }
        return folderList;
    }

    public static MenuResultObj getMenuData(String basePath, String jsessionId, String localeCode) throws ServiceException, Exception {
        if (LocaleLanguageUtils.getMap().get(localeCode) == null) {
            localeCode = LocaleLanguageUtils.getDefault();
        }
        HashMap<String, String> orderParams = new HashMap<String, String>();
        orderParams.put("name", "asc");
        List sysList = sysService.findListByParams(null, null, orderParams);
        if (sysList == null || sysList.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
        }
        MenuResultObj resultObj = new MenuResultObj();
        StringBuilder jsSb = new StringBuilder();
        StringBuilder htmlSb = new StringBuilder();
        StringBuilder dlgSb = new StringBuilder();
        jsSb.append("var ").append("_applicationProgramNameData").append(" = new Object();\t").append("\n");
        jsSb.append("function ").append("_getApplicationProgramNameById(progId)").append(" {\t\t\t\t").append("\n");
        jsSb.append("\tvar name = ").append("_applicationProgramNameData").append("[progId];").append("\n");
        jsSb.append("\tif (name == null) {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append("\n");
        jsSb.append("\t\treturn progId;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append("\n");
        jsSb.append("\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append("\n");
        jsSb.append("\treturn name;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append("\n");
        jsSb.append("}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append("\n");
        for (TbSys sys : sysList) {
            Map<String, String> menuData = MenuSupportUtils.getMenuData(basePath, sys, jsessionId, localeCode);
            jsSb.append(StringUtils.defaultString(menuData.get(MENU_ITEM_JAVASCRIPT)));
            htmlSb.append(StringUtils.defaultString(menuData.get(MENU_ITEM_HTML)));
            dlgSb.append(StringUtils.defaultString(menuData.get(MENU_ITEM_DIALOG)));
        }
        resultObj.setJavascriptData(jsSb.toString());
        resultObj.setHtmlData(htmlSb.toString());
        resultObj.setDialogHtmlData(dlgSb.toString());
        return resultObj;
    }

    public static List<Map<String, Object>> getMenuTreeJsonData(String basePath, String localeCode) throws ServiceException, Exception {
        HashMap<String, String> orderParams = new HashMap<String, String>();
        orderParams.put("name", "asc");
        List<TbSys> sysList = sysService.findListByParams(null, null, orderParams);
        if (sysList == null || sysList.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
        }
        return MenuSupportUtils.getMenuTreeJsonData(basePath, sysList, localeCode);
    }

    public static String getMenuTreeJsonDataStr(String basePath, String localeCode) throws ServiceException, Exception {
        List<Map<String, Object>> menuJsonList = MenuSupportUtils.getMenuTreeJsonData(basePath, localeCode);
        return JSONArray.fromObject(menuJsonList).toString();
    }

    public static Map<String, String> getMenuData(String basePath, TbSys sys, String jsessionId, String localeCode) throws ServiceException, Exception {
        HashMap<String, String> menuData = new HashMap<String, String>();
        List<SysMenuVO> menuList = MenuSupportUtils.loadSysMenuData(sys.getSysId());
        if (!(menuList != null && menuList.size() >= 1 || Constants.getSystem().equals(sys.getSysId()))) {
            return menuData;
        }
        StringBuilder htmlSb = new StringBuilder();
        StringBuilder jsSb = new StringBuilder();
        StringBuilder dlgSb = new StringBuilder();
        HashMap<String, String> jsFunctionMap = new HashMap<String, String>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("progSystem", sys.getSysId());
        List sysProgList = sysProgService.findListByParams(params);
        int i = 0;
        while (sysProgList != null && i < sysProgList.size()) {
            TbSysProg sysProg = (TbSysProg)sysProgList.get(i);
            if (!"FOLDER".equals(sysProg.getItemType())) {
                String openTabFn = String.valueOf(sysProg.getProgId()) + "_TabShow()";
                if ("Y".equals(sysProg.getEditMode())) {
                    openTabFn = String.valueOf(sysProg.getProgId()) + "_TabShow(oid)";
                }
                String refreshTabFn = String.valueOf(sysProg.getProgId()) + "_TabRefresh()";
                String closeTabFn = String.valueOf(sysProg.getProgId()) + "_TabClose()";
                String tabId = String.valueOf(sysProg.getProgId()) + "_ChildTab";
                boolean iframeMode = false;
                if ("Y".equals(sysProg.getIsWindow())) {
                    iframeMode = true;
                }
                String progMultiName = MenuSupportUtils.getProgramMultiName(sysProg, localeCode);
                jsSb.append("function ").append(openTabFn).append(" { ");
                jsSb.append("\tviewPage.addOrUpdateContentPane(\t");
                jsSb.append("\t\t'").append("gscoreTabContainer").append("',\t");
                jsSb.append("\t\t'").append(tabId).append("',\t");
                jsSb.append("\t\t'").append(StringEscapeUtils.escapeEcmaScript(IconUtils.getMenuIcon(basePath, sysProg.getIcon()))).append(StringEscapeUtils.escapeEcmaScript(progMultiName)).append("',\t");
                if ("Y".equals(sysProg.getEditMode())) {
                    jsSb.append("\t\t'").append(MenuSupportUtils.getUrl(basePath, sys, sysProg, jsessionId)).append("&fields.oid=' + oid,\t");
                } else {
                    jsSb.append("\t\t'").append(MenuSupportUtils.getUrl(basePath, sys, sysProg, jsessionId)).append("',\t");
                }
                jsSb.append("\t\ttrue,\t");
                jsSb.append("\t\ttrue,\t");
                jsSb.append("\t").append(String.valueOf(iframeMode)).append("\t");
                jsSb.append("\t);\t");
                jsSb.append("}\t");
                jsSb.append("\n");
                jsSb.append("function ").append(refreshTabFn).append(" { ");
                jsSb.append("\tviewPage.refreshContentPane('").append(tabId).append("'); ");
                jsSb.append("}\t");
                jsSb.append("\n");
                jsSb.append("function ").append(closeTabFn).append(" { ");
                jsSb.append("\tviewPage.closeContentPane('").append("gscoreTabContainer").append("', '").append(tabId).append("'); ");
                jsSb.append("}\t");
                jsSb.append("\n");
                jsSb.append("_applicationProgramNameData").append("['").append(sysProg.getProgId()).append("'] = '").append(StringEscapeUtils.escapeEcmaScript(progMultiName)).append("';");
                jsSb.append("\n");
                jsFunctionMap.put(sysProg.getProgId(), openTabFn);
                String dlgId = "";
                if ("Y".equals(sysProg.getIsDialog())) {
                    dlgId = String.valueOf(sysProg.getProgId()) + "_Dlg";
                }
                if (!StringUtils.isBlank(dlgId)) {
                    dlgSb.append("<div id=\"" + dlgId + "\" data-dojo-type=\"dojox.widget.DialogSimple\" ").append("data-dojo-props='href:\"").append(MenuSupportUtils.getUrl(basePath, sys, sysProg, jsessionId)).append("\",").append("\tstyle:\"width: ").append(sysProg.getDialogW()).append("px; height: ").append(sysProg.getDialogH()).append("px\",").append("\ttitle:\"").append(IconUtils.getMenuIcon(basePath, sysProg.getIcon()).replaceAll("'", "\\\\\"")).append(StringEscapeUtils.escapeEcmaScript(progMultiName)).append("\",").append("\trefreshOnShow:\"true\", executeScripts:\"true\" ").append(" '></div>").append("\n");
                    String dlgOpenFn = String.valueOf(sysProg.getProgId()) + "_DlgShow()";
                    String dlgHideFn = String.valueOf(sysProg.getProgId()) + "_DlgHide()";
                    if ("Y".equals(sysProg.getEditMode())) {
                        dlgOpenFn = String.valueOf(sysProg.getProgId()) + "_DlgShow(oid)";
                    }
                    jsSb.append("function ").append(dlgOpenFn).append(" { ");
                    String dlgUrl = "";
                    if ("Y".equals(sysProg.getEditMode())) {
                        dlgUrl = "'" + MenuSupportUtils.getUrl(basePath, sys, sysProg, jsessionId) + "&fields.oid=' + oid; ";
                        jsSb.append("\tvar dlgUrl=").append(dlgUrl);
                        jsSb.append("\tdijit.byId('").append(dlgId).append("').set('href', dlgUrl); ");
                    }
                    jsSb.append("\tdijit.byId('").append(dlgId).append("').show();\t");
                    jsSb.append("}\t");
                    jsSb.append("\n");
                    jsSb.append("function ").append(dlgHideFn).append(" { ");
                    jsSb.append("\tdijit.byId('").append(dlgId).append("').hide();\t");
                    jsSb.append("}\t");
                    jsSb.append("\n");
                }
            }
            ++i;
        }
        htmlSb.append("<div data-dojo-type='dijit.PopupMenuItem' >");
        htmlSb.append("\t<span>").append(IconUtils.getMenuIcon(basePath, sys.getIcon())).append(MenuSupportUtils.getSystemMultiName(sys, localeCode)).append("</span>");
        List<SysMenuVO> parentSysMenuList = MenuSupportUtils.searchFolder(menuList);
        htmlSb.append("<div dojoType='dijit.Menu' >");
        for (SysMenuVO sysMenu : parentSysMenuList) {
            List<SysMenuVO> itemSysMenuList = MenuSupportUtils.searchItem(sysMenu.getOid(), menuList);
            if (itemSysMenuList == null || itemSysMenuList.size() < 1) continue;
            String multiProgName = MenuSupportUtils.getProgramMultiName(sysMenu, localeCode);
            htmlSb.append("<div data-dojo-type='dijit.PopupMenuItem' >");
            htmlSb.append("<span>").append(IconUtils.getMenuIcon(basePath, sysMenu.getIcon())).append(multiProgName).append("</span>");
            htmlSb.append("<div data-dojo-type='dijit.Menu' >");
            for (SysMenuVO itemMenu : itemSysMenuList) {
                String itemMultiProgName = MenuSupportUtils.getProgramMultiName(itemMenu, localeCode);
                htmlSb.append("<div data-dojo-type='dijit.MenuItem' data-dojo-props='onClick:function(){ ").append(StringUtils.defaultString((String)jsFunctionMap.get(itemMenu.getProgId()))).append(" }'>").append(IconUtils.getMenuIcon(basePath, itemMenu.getIcon())).append(itemMultiProgName).append("</div>");
            }
            htmlSb.append("</div>");
            htmlSb.append("</div>");
        }
        htmlSb.append("</div>");
        htmlSb.append("</div>");
        menuData.put(MENU_ITEM_JAVASCRIPT, jsSb.toString());
        menuData.put(MENU_ITEM_HTML, htmlSb.toString());
        menuData.put(MENU_ITEM_DIALOG, dlgSb.toString());
        return menuData;
    }

    public static List<Map<String, Object>> getMenuTreeJsonData(String basePath, List<TbSys> sysList, String localeCode) throws ServiceException, Exception {
        if (LocaleLanguageUtils.getMap().get(localeCode) == null) {
            localeCode = LocaleLanguageUtils.getDefault();
        }
        LinkedList<Map<String, Object>> treeMenuList = new LinkedList<Map<String, Object>>();
        for (TbSys sys : sysList) {
            List<SysMenuVO> sysMenuList = MenuSupportUtils.loadSysMenuData(sys.getSysId());
            if (sysMenuList == null || sysMenuList.size() < 1) continue;
            String multiSysName = MenuSupportUtils.getSystemMultiName(sys, localeCode);
            HashMap<String, Object> systemMap = new HashMap<String, Object>();
            systemMap.put("id", sys.getSysId());
            systemMap.put("progId", sys.getSysId());
            systemMap.put("name", multiSysName);
            systemMap.put("type", "FOLDER");
            systemMap.put("onclick", " ");
            systemMap.put("label", String.valueOf(IconUtils.getMenuIcon(basePath, sys.getIcon())) + StringEscapeUtils.escapeHtml4(multiSysName));
            LinkedList sysItemList = new LinkedList();
            List<SysMenuVO> folderList = MenuSupportUtils.searchFolder(sysMenuList);
            for (SysMenuVO sysMenu : folderList) {
                List<SysMenuVO> menuItemList = MenuSupportUtils.searchItem(sysMenu.getOid(), sysMenuList);
                if (menuItemList == null || menuItemList.size() < 1) continue;
                String menuProgMultiName = MenuSupportUtils.getProgramMultiName(sysMenu, localeCode);
                HashMap<String, Object> sysMenuMap = new HashMap<String, Object>();
                sysMenuMap.put("id", sysMenu.getOid());
                sysMenuMap.put("progId", sysMenu.getProgId());
                sysMenuMap.put("name", menuProgMultiName);
                sysMenuMap.put("type", sysMenu.getItemType());
                sysMenuMap.put("onclick", " ");
                sysMenuMap.put("label", String.valueOf(IconUtils.getMenuIcon(basePath, sysMenu.getIcon())) + StringEscapeUtils.escapeHtml4(menuProgMultiName));
                LinkedList childItemList = new LinkedList();
                for (SysMenuVO menuItem : menuItemList) {
                    String menuItemProgMultiName = MenuSupportUtils.getProgramMultiName(menuItem, localeCode);
                    HashMap<String, String> itemMap = new HashMap<String, String>();
                    itemMap.put("id", menuItem.getOid());
                    itemMap.put("progId", menuItem.getProgId());
                    itemMap.put("name", menuItemProgMultiName);
                    itemMap.put("type", menuItem.getItemType());
                    itemMap.put("parent", menuItem.getParentOid());
                    itemMap.put("onclick", String.valueOf(menuItem.getProgId()) + "_TabShow()");
                    itemMap.put("label", String.valueOf(IconUtils.getMenuIcon(basePath, menuItem.getIcon())) + StringEscapeUtils.escapeHtml4(menuItemProgMultiName));
                    childItemList.add(itemMap);
                }
                sysMenuMap.put("children", childItemList);
                sysItemList.add(sysMenuMap);
            }
            if (sysItemList.size() <= 0) continue;
            systemMap.put("children", sysItemList);
            treeMenuList.add(systemMap);
        }
        return treeMenuList;
    }

    public static String getProgramName(String progId) {
        String name = "unknown-program";
        if (StringUtils.isBlank(progId)) {
            return name;
        }
        try {
            name = sysProgService.findNameForProgId(progId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    public static String getProgramName(String progId, String localeCode) {
        if (StringUtils.isBlank(progId)) {
            return "unknown-program";
        }
        String defaultName = "unknown-program";
        String multiName = "unknown-program";
        defaultName = MenuSupportUtils.getProgramName(progId);
        if (LocaleLanguageUtils.getMap().get(localeCode) == null) {
            return defaultName;
        }
        TbSysProg sysProg = new TbSysProg();
        sysProg.setName(defaultName);
        sysProg.setProgId(progId);
        try {
            multiName = MenuSupportUtils.getProgramMultiName(sysProg, localeCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!StringUtils.isBlank(multiName)) {
            return multiName;
        }
        return defaultName;
    }

    public static String getTwitterAccordionPane() throws ServiceException, Exception {
        Map<String, Object> settingsMap = Constants.getSettingsMap();
        if (SimpleUtils.getStr((String)settingsMap.get("twitter.enable"), "N").toUpperCase().equals("N")) {
            return "";
        }
        List sysList = sysService.findListByParams(null);
        if (sysList == null || sysList.size() < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (TbSys sys : sysList) {
            sb.append(MenuSupportUtils.getTwitterAccordionPane(sys.getSysId()));
        }
        return sb.toString();
    }

    public static String getTwitterAccordionPane(String systemId) throws ServiceException, Exception {
        if (StringUtils.isBlank(systemId)) {
            return "";
        }
        SysTwitterVO sysTwitter = new SysTwitterVO();
        sysTwitter.setSystem(systemId);
        DefaultResult<SysTwitterVO> result = sysTwitterService.findByUK(sysTwitter);
        if (result.getValue() == null) {
            return "";
        }
        sysTwitter = result.getValue();
        if (!"Y".equals(sysTwitter.getEnableFlag())) {
            return "";
        }
        String content = new String(sysTwitter.getContent(), "utf8");
        if (StringUtils.isBlank(content)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String title = StringEscapeUtils.escapeHtml4(sysTwitter.getTitle());
        String id = "_" + systemId + "_twitter_AccordionPane";
        sb.append("<div data-dojo-type=\"dijit/layout/AccordionPane\" title=\"<img src='./icons/twitter.png' border='0'/>&nbsp;" + title + "\" id=\"" + id + "\"> \n");
        sb.append(content);
        sb.append("\n");
        sb.append("</div>");
        return sb.toString();
    }

    public static String getFirstLoadJavascript() throws ServiceException, Exception {
        return SystemSettingConfigureUtils.getFirstLoadJavascriptValue();
    }

    public static String getSystemMultiName(TbSys system, String localeCode) throws ServiceException, Exception {
        if (system == null) {
            return "unknown-system";
        }
        if (LocaleLanguageUtils.getMap().get(localeCode) == null) {
            return system.getName();
        }
        TbSysMultiName multiName = new TbSysMultiName();
        multiName.setSysId(system.getSysId());
        multiName.setLocaleCode(localeCode);
        multiName = sysMultiNameService.findByEntityUK(multiName);
        if (multiName != null && !StringUtils.isBlank(multiName.getName()) && "Y".equals(multiName.getEnableFlag())) {
            return multiName.getName();
        }
        return system.getName();
    }

    public static String getProgramMultiName(TbSysProg sysProg, String localeCode) throws ServiceException, Exception {
        if (sysProg == null) {
            return "unknown-program";
        }
        if (LocaleLanguageUtils.getMap().get(localeCode) == null) {
            return sysProg.getName();
        }
        TbSysProgMultiName multiName = new TbSysProgMultiName();
        multiName.setProgId(sysProg.getProgId());
        multiName.setLocaleCode(localeCode);
        multiName = sysProgMultiNameService.findByEntityUK(multiName);
        if (multiName != null && !StringUtils.isBlank(multiName.getName()) && "Y".equals(multiName.getEnableFlag())) {
            return multiName.getName();
        }
        return sysProg.getName();
    }

    public static String getProgramMultiName(SysMenuVO menu, String localeCode) throws ServiceException, Exception {
        TbSysProg sysProg = new TbSysProg();
        sysProg.setProgId(menu.getProgId());
        sysProg.setName(menu.getName());
        return MenuSupportUtils.getProgramMultiName(sysProg, localeCode);
    }
}

