/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.util.SystemSettingConfigureUtils;
import java.io.File;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailClientUtils {
    private static JavaMailSender mailSender;
    private static ThreadLocal<String> formTL;
    private static ThreadLocal<String> enableTL;

    static {
        formTL = new ThreadLocal();
        enableTL = new ThreadLocal();
        mailSender = (JavaMailSender)AppContext.getBean("mailSender");
    }

    public static String getDefaultFrom() {
        if (formTL.get() == null) {
            formTL.set(SystemSettingConfigureUtils.getMailDefaultFromValue());
        }
        return StringUtils.defaultString(formTL.get());
    }

    public static boolean getEnable() {
        if (enableTL.get() == null) {
            enableTL.set(SystemSettingConfigureUtils.getMailEnableValue());
        }
        return StringUtils.defaultString(enableTL.get()).trim().equals("Y");
    }

    public static void clearThreadLocal() {
        formTL.remove();
        enableTL.remove();
    }

    public static void send(String from, String to, String subject, String text) throws MailException, Exception {
        MailClientUtils.send(from, to, null, null, null, null, subject, text);
    }

    public static void send(String from, String to, String[] cc, String subject, String text) throws MailException, Exception {
        MailClientUtils.send(from, to, cc, null, null, null, subject, text);
    }

    public static void send(String from, String to, String[] cc, String[] bcc, String subject, String text) throws MailException, Exception {
        MailClientUtils.send(from, to, cc, bcc, null, null, subject, text);
    }

    public static void send(String from, String to, String cc, String bcc, String subject, String text) throws MailException, Exception {
        String[] mailCc = null;
        String[] mailBcc = null;
        if (!StringUtils.isBlank(cc)) {
            mailCc = cc.split(";");
        }
        if (!StringUtils.isBlank(bcc)) {
            mailBcc = bcc.split(";");
        }
        MailClientUtils.send(from, to, mailCc, mailBcc, subject, text);
    }

    public static void send(String from, String to, String[] cc, String[] bcc, String[] fileNames, File[] files, String subject, String text) throws MailException, Exception {
        if (mailSender == null) {
            throw new Exception("null mailSender!");
        }
        if (StringUtils.isBlank(from) || StringUtils.isBlank(to)) {
            throw new Exception("from and to is required!");
        }
        if (fileNames != null && files != null && fileNames.length != files.length) {
            throw new Exception("File parameter error!");
        }
        MimeMessage message = mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true, "utf-8");
        helper.setFrom(from);
        helper.setTo(to.endsWith(";") ? to.substring(0, to.length() - 1) : to);
        helper.setSubject(subject);
        helper.setText(text, true);
        if (cc != null && cc.length > 0) {
            helper.setCc(cc);
        }
        if (bcc != null && bcc.length > 0) {
            helper.setBcc(bcc);
        }
        int i = 0;
        while (fileNames != null && i < fileNames.length) {
            helper.addAttachment(fileNames[i], files[i]);
            ++i;
        }
        mailSender.send(message);
    }
}

