/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.po.hbm.TbSysJreport;
import com.netsteadfast.greenstep.po.hbm.TbSysJreportParam;
import com.netsteadfast.greenstep.service.ISysJreportParamService;
import com.netsteadfast.greenstep.service.ISysJreportService;
import com.netsteadfast.greenstep.util.DataUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import com.netsteadfast.greenstep.vo.SysJreportParamVO;
import com.netsteadfast.greenstep.vo.SysJreportVO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lingala.zip4j.core.ZipFile;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimplePdfExporterConfiguration;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class JReportUtils {
    protected static Logger logger = Logger.getLogger(JReportUtils.class);
    private static ISysJreportService<SysJreportVO, TbSysJreport, String> sysJreportService = (ISysJreportService)AppContext.getBean("core.service.SysJreportService");
    private static ISysJreportParamService<SysJreportParamVO, TbSysJreportParam, String> sysJreportParamService = (ISysJreportParamService)AppContext.getBean("core.service.SysJreportParamService");

    public static void deployReport(SysJreportVO report) throws Exception {
        TbSysJreport destReportObj = new TbSysJreport();
        BeanUtils.copyProperties(destReportObj, report);
        JReportUtils.deployReport(destReportObj);
    }

    public static void deployReport(TbSysJreport report) throws Exception {
        File reportDeployDir;
        block17: {
            OutputStream os;
            File reportZipFile;
            File reportFile;
            block18: {
                String reportDeployDirName;
                block15: {
                    block16: {
                        reportDeployDirName = String.valueOf(Constants.getDeployJasperReportDir()) + "/";
                        reportDeployDir = new File(reportDeployDirName);
                        try {
                            if (!reportDeployDir.exists()) {
                                logger.warn("no exists dir, force mkdir " + reportDeployDirName);
                                FileUtils.forceMkdir(reportDeployDir);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            logger.error(e.getMessage().toString());
                        }
                        logger.info("REPORT-ID : " + report.getReportId());
                        reportFile = null;
                        reportZipFile = null;
                        os = null;
                        String reportFileFullPath = String.valueOf(reportDeployDirName) + report.getReportId() + "/" + report.getFile();
                        String reportZipFileFullPath = String.valueOf(reportDeployDirName) + report.getReportId() + ".zip";
                        reportZipFile = new File(reportZipFileFullPath);
                        if (reportZipFile.exists()) {
                            logger.warn("delete " + reportZipFileFullPath);
                            FileUtils.forceDelete(reportZipFile);
                        }
                        os = new FileOutputStream(reportZipFile);
                        IOUtils.write(report.getContent(), os);
                        os.flush();
                        ZipFile zipFile = new ZipFile(reportZipFileFullPath);
                        zipFile.extractAll(reportDeployDirName);
                        reportFile = new File(reportFileFullPath);
                        if (reportFile.exists()) break block15;
                        logger.warn("report file is missing : " + reportFileFullPath);
                        if (os == null) break block16;
                        os.close();
                    }
                    os = null;
                    reportFile = null;
                    reportZipFile = null;
                    return;
                }
                try {
                    if ("Y".equals(report.getIsCompile()) && report.getFile().endsWith("jrxml")) {
                        logger.info("compile report...");
                        File d = new File(String.valueOf(reportDeployDirName) + report.getReportId());
                        String outJasper = JReportUtils.compileReportToJasperFile(d.listFiles(), String.valueOf(reportDeployDirName) + report.getReportId() + "/");
                        logger.info("out first : " + outJasper);
                    }
                }
                catch (JRException re) {
                    re.printStackTrace();
                    logger.error(re.getMessage().toString());
                    if (os != null) {
                        os.close();
                    }
                    os = null;
                    reportFile = null;
                    reportZipFile = null;
                    break block17;
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                        logger.error(e.getMessage().toString());
                        break block17;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (os != null) {
                            os.close();
                        }
                        os = null;
                        reportFile = null;
                        reportZipFile = null;
                    }
                }
                if (os == null) break block18;
                os.close();
            }
            os = null;
            reportFile = null;
            reportZipFile = null;
        }
        reportDeployDir = null;
    }

    public static void deploy() throws ServiceException, Exception {
        logger.info("begin deploy...");
        List reports = sysJreportService.findListByParams(null);
        String reportDeployDirName = String.valueOf(Constants.getDeployJasperReportDir()) + "/";
        File reportDeployDir = new File(reportDeployDirName);
        try {
            if (reportDeployDir.exists()) {
                logger.warn("delete " + reportDeployDirName);
                FileUtils.forceDelete(reportDeployDir);
            }
            logger.warn("mkdir " + reportDeployDirName);
            FileUtils.forceMkdir(reportDeployDir);
            for (TbSysJreport report : reports) {
                JReportUtils.deployReport(report);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage().toString());
        }
        reportDeployDir = null;
        logger.info("end deploy...");
    }

    public static String compileReportToJasperFile(File[] sourceFile, String destDir) throws JRException {
        String jasperFirst = "";
        int ix = 0;
        while (sourceFile != null && ix < sourceFile.length) {
            File srcFile = sourceFile[ix];
            if (!srcFile.exists() || srcFile.getName().indexOf(".jrxml") == -1) {
                srcFile = null;
            } else {
                String destFileName = srcFile.getPath().replaceAll(".jrxml", ".jasper");
                if ("".equals(jasperFirst)) {
                    jasperFirst = destFileName;
                }
                JasperCompileManager.compileReportToFile(srcFile.getPath(), destFileName);
                logger.info("out process : " + destFileName);
            }
            ++ix;
        }
        return jasperFirst;
    }

    public static String compileReportToJasperFile(String[] sourceFileName, String destDir) throws JRException {
        String jasperFirst = "";
        int ix = 0;
        while (sourceFileName != null && ix < sourceFileName.length) {
            File srcFile = new File(sourceFileName[ix]);
            if (!srcFile.exists() || srcFile.getName().indexOf(".jrxml") == -1) {
                srcFile = null;
            } else {
                String destFileName = srcFile.getPath().replaceAll(".jrxml", ".jasper");
                if ("".equals(jasperFirst)) {
                    jasperFirst = destFileName;
                }
                JasperCompileManager.compileReportToFile(srcFile.getPath(), destFileName);
                logger.info("out process : " + destFileName);
            }
            ++ix;
        }
        return jasperFirst;
    }

    public static String selfTestDecompress4Upload(String uploadOid) throws ServiceException, IOException, Exception {
        String extractDir = String.valueOf(Constants.getWorkTmpDir()) + "/" + JReportUtils.class.getSimpleName() + "/" + SimpleUtils.getUUIDStr() + "/";
        File realFile = UploadSupportUtils.getRealFile(uploadOid);
        try {
            ZipFile zipFile = new ZipFile(realFile);
            zipFile.extractAll(extractDir);
        }
        finally {
            realFile = null;
        }
        return extractDir;
    }

    public static Map<String, Object> getParameter(String reportId, HttpServletRequest request) throws ServiceException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (StringUtils.isBlank(reportId)) {
            return paramMap;
        }
        paramMap.put("reportId", reportId);
        List paramList = sysJreportParamService.findListByParams(paramMap);
        paramMap.clear();
        int i = 0;
        while (paramList != null && i < paramList.size()) {
            TbSysJreportParam sysJreportParam = (TbSysJreportParam)paramList.get(i);
            Enumeration urlParams = request.getParameterNames();
            while (urlParams.hasMoreElements()) {
                String p = (String)urlParams.nextElement();
                if (!p.equals(sysJreportParam.getUrlParam())) continue;
                String value = request.getParameter(p);
                paramMap.put(sysJreportParam.getRptParam(), value);
            }
            ++i;
        }
        String reportFolder = String.valueOf(Constants.getDeployJasperReportDir()) + File.separator + reportId + File.separator;
        paramMap.put("REPORT_FOLDER", reportFolder);
        paramMap.put("SUBREPORT_DIR", reportFolder);
        return paramMap;
    }

    public static void fillReportToResponse(String reportId, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception {
        Map<String, Object> paramMap = JReportUtils.getParameter(reportId, request);
        JReportUtils.fillReportToResponse(reportId, paramMap, response);
    }

    public static void fillReportToResponse(String reportId, Map<String, Object> paramMap, HttpServletResponse response) throws ServiceException, Exception {
        if (StringUtils.isBlank(reportId)) {
            throw new IllegalArgumentException("error, reportId is blank");
        }
        TbSysJreport sysJreport = new TbSysJreport();
        sysJreport.setReportId(reportId);
        DefaultResult<TbSysJreport> result = sysJreportService.findEntityByUK(sysJreport);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        sysJreport = result.getValue();
        String jasperFileFullPath = String.valueOf(Constants.getDeployJasperReportDir()) + "/" + sysJreport.getReportId() + "/" + sysJreport.getReportId() + ".jasper";
        File jasperFile = new File(jasperFileFullPath);
        if (!jasperFile.exists()) {
            jasperFile = null;
            throw new Exception("error, Files are missing : " + jasperFileFullPath);
        }
        FileInputStream reportSource = new FileInputStream(jasperFile);
        Connection conn = null;
        try {
            try {
                conn = DataUtils.getConnection();
                ServletOutputStream ouputStream = response.getOutputStream();
                JasperPrint jasperPrint = JasperFillManager.fillReport((InputStream)reportSource, paramMap, conn);
                response.setContentType("application/pdf");
                response.setHeader("Content-disposition", "inline; filename=" + sysJreport.getReportId() + ".pdf");
                JRPdfExporter jrPdfExporter = new JRPdfExporter();
                jrPdfExporter.setExporterInput(new SimpleExporterInput(jasperPrint));
                jrPdfExporter.setExporterOutput(new SimpleOutputStreamExporterOutput((OutputStream)ouputStream));
                SimplePdfExporterConfiguration configuration = new SimplePdfExporterConfiguration();
                jrPdfExporter.setConfiguration(configuration);
                configuration.setOwnerPassword(Constants.getEncryptorKey1());
                jrPdfExporter.exportReport();
                ouputStream.flush();
                ouputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                DataUtils.doReleaseConnection(conn);
                if (reportSource != null) {
                    try {
                        ((InputStream)reportSource).close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                reportSource = null;
                jasperFile = null;
            }
        }
        finally {
            DataUtils.doReleaseConnection(conn);
            if (reportSource != null) {
                try {
                    ((InputStream)reportSource).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            reportSource = null;
            jasperFile = null;
        }
    }
}

