/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.util.DataUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import com.netsteadfast.greenstep.xmlbeans.exportdata.ExportDataConfig;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class ExportData2CsvUtils {
    protected static Logger logger = Logger.getLogger(ExportData2CsvUtils.class);
    private static final String META_CONF_DIR = "META-INF/resource/export_data_config";

    private static ExportDataConfig getConfig(String configXmlFile) throws Exception {
        InputStream is = ExportData2CsvUtils.class.getClassLoader().getResource("META-INF/resource/export_data_config/" + configXmlFile).openStream();
        byte[] xmlContent = IOUtils.toString(is, "utf-8").getBytes();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ExportDataConfig.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        ByteArrayInputStream bais = new ByteArrayInputStream(xmlContent);
        ExportDataConfig config = (ExportDataConfig)jaxbUnmarshaller.unmarshal((InputStream)bais);
        return config;
    }

    public static String create(String configXmlFile, NamedParameterJdbcTemplate jdbcTemplate, Map<String, Object> sqlParamMap) throws ServiceException, Exception {
        ExportDataConfig config = ExportData2CsvUtils.getConfig(configXmlFile);
        String csvText = ExportData2CsvUtils.processCsvText(config, jdbcTemplate, sqlParamMap);
        return ExportData2CsvUtils.createUpload(config, csvText);
    }

    public static String create(String configXmlFile, Map<String, Object> sqlParamMap) throws ServiceException, Exception {
        ExportDataConfig config = ExportData2CsvUtils.getConfig(configXmlFile);
        String csvText = ExportData2CsvUtils.processCsvText(config, DataUtils.getJdbcTemplate(), sqlParamMap);
        return ExportData2CsvUtils.createUpload(config, csvText);
    }

    private static String createUpload(ExportDataConfig config, String csvText) throws ServiceException, Exception {
        return UploadSupportUtils.create(Constants.getSystem(), "tmp", false, csvText.getBytes(), String.valueOf(config.getId()) + ".csv");
    }

    private static String processCsvText(ExportDataConfig config, NamedParameterJdbcTemplate jdbcTemplate, Map<String, Object> sqlParamMap) throws Exception {
        logger.info("export-Id: " + config.getId() + " name: " + config.getName());
        StringBuilder out = new StringBuilder();
        out.append(config.getTitle()).append("\r\n");
        List<Map<String, Object>> results = jdbcTemplate.queryForList(config.getSql(), sqlParamMap);
        int i = 0;
        while (results != null && i < results.size()) {
            Map<String, Object> dataMap = results.get(i);
            for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                if (entry.getValue() != null) {
                    String str = "";
                    str = entry.getValue() instanceof byte[] ? new String((byte[])entry.getValue(), "utf-8") : String.valueOf(entry.getValue());
                    if (config.isEscapeCsv()) {
                        str = SimpleUtils.escapeCsv(str);
                    }
                    if (StringUtils.isBlank(str)) {
                        str = " ";
                    }
                    out.append("\"").append(str).append("\"");
                } else {
                    out.append(" ");
                }
                out.append(config.getSeparateSymbol());
            }
            out.append("\r\n");
            ++i;
        }
        return out.toString();
    }
}

