/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.po.hbm.TbSys;
import com.netsteadfast.greenstep.service.ISysService;
import com.netsteadfast.greenstep.util.FSUtils;
import com.netsteadfast.greenstep.util.HostUtils;
import com.netsteadfast.greenstep.vo.SysVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ApplicationSiteUtils {
    protected static Logger logger = Logger.getLogger(ApplicationSiteUtils.class);
    public static final String UPDATE_HOST_ALWAYS = "2";
    public static final String UPDATE_HOST_ONLY_FIRST_ONE = "1";
    private static final int TEST_JSON_HTTP_TIMEOUT = 3000;
    private static Map<String, String> contextPathMap = new HashMap<String, String>();

    public static List<SysVO> getSystems() throws ServiceException, Exception {
        ISysService sysService = (ISysService)AppContext.getBean("core.service.SysService");
        return sysService.findListVOByParams(null);
    }

    public static String getHost(String sysId) {
        DefaultResult<SysVO> result;
        SysVO sys;
        String host;
        block4: {
            host = "";
            ISysService sysService = (ISysService)AppContext.getBean("core.service.SysService");
            sys = new SysVO();
            sys.setSysId(sysId);
            result = sysService.findByUK(sys);
            if (result.getValue() != null) break block4;
            return "";
        }
        try {
            sys = result.getValue();
            host = sys.getHost();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return host;
    }

    public static String getBasePath(String sysId, HttpServletRequest request) {
        String basePath = String.valueOf(request.getScheme()) + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/";
        if (StringUtils.isBlank(sysId)) {
            return basePath;
        }
        ISysService sysService = (ISysService)AppContext.getBean("core.service.SysService");
        SysVO sys = new SysVO();
        sys.setSysId(sysId);
        try {
            DefaultResult<SysVO> result = sysService.findByUK(sys);
            if (result.getValue() == null) {
                return basePath;
            }
            sys = result.getValue();
            basePath = String.valueOf(request.getScheme()) + "://" + sys.getHost() + "/" + sys.getContextPath() + "/";
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return basePath;
    }

    public static String getContextPath(String sysId) {
        String contextPath = "";
        ISysService sysService = (ISysService)AppContext.getBean("core.service.SysService");
        SysVO sys = new SysVO();
        sys.setSysId(sysId);
        try {
            DefaultResult<SysVO> result = sysService.findByUK(sys);
            if (result.getValue() == null) {
                return contextPath;
            }
            sys = result.getValue();
            contextPath = sys.getContextPath();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contextPath;
    }

    public static String getContextPathFromMap(String sysId) {
        if (contextPathMap.get(sysId) != null) {
            return contextPathMap.get(sysId);
        }
        String contextPath = ApplicationSiteUtils.getContextPath(sysId);
        if (!StringUtils.isBlank(contextPath)) {
            contextPathMap.put(sysId, contextPath);
        }
        return contextPath;
    }

    public static void configureHost(String sysId, String logConfFileFullPath) {
        String logValue = FSUtils.readStr(logConfFileFullPath).trim();
        if (!StringUtils.isBlank(logValue) && UPDATE_HOST_ONLY_FIRST_ONE.equals(Constants.getApplicationSiteHostUpdateMode())) {
            FSUtils.writeStr2(logConfFileFullPath, UPDATE_HOST_ONLY_FIRST_ONE);
            return;
        }
        ISysService sysService = (ISysService)AppContext.getBean("core.service.SysService");
        SysVO sys = new SysVO();
        sys.setSysId(sysId);
        try {
            DefaultResult<SysVO> result = sysService.findByUK(sys);
            if (result.getValue() == null) {
                System.out.println(result.getSystemMessage().getValue());
                return;
            }
            sys = result.getValue();
            String port = String.valueOf(HostUtils.getHttpPort());
            String hostAddress = HostUtils.getHostAddress();
            sys.setHost(hostAddress);
            if (!StringUtils.isBlank(port)) {
                sys.setHost(String.valueOf(hostAddress) + ":" + port);
            }
            sysService.updateObject(sys);
            if (UPDATE_HOST_ALWAYS.equals(Constants.getApplicationSiteHostUpdateMode())) {
                FSUtils.writeStr2(logConfFileFullPath, UPDATE_HOST_ALWAYS);
            } else {
                FSUtils.writeStr2(logConfFileFullPath, UPDATE_HOST_ONLY_FIRST_ONE);
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean checkCrossSite(String host, HttpServletRequest request) {
        boolean corssSite = false;
        String basePath = String.valueOf(request.getScheme()) + "://" + request.getServerName() + ":" + request.getServerPort();
        String basePath80 = String.valueOf(request.getScheme()) + "://" + request.getServerName();
        basePath = basePath.toLowerCase();
        basePath80 = basePath80.toLowerCase();
        if (request.getServerPort() == 80 || request.getServerPort() == 443) {
            if (basePath.indexOf(host) == -1 && basePath80.indexOf(host) == -1) {
                corssSite = true;
            }
        } else if (basePath.indexOf(host) == -1) {
            corssSite = true;
        }
        return corssSite;
    }

    private static boolean checkTestConnection(String host, String contextPath, HttpServletRequest request) {
        boolean test = false;
        String basePath = String.valueOf(request.getScheme()) + "://" + host + "/" + contextPath;
        String urlStr = String.valueOf(basePath) + "/pages/system/testJsonResult.action";
        try {
            logger.info("checkTestConnection , url=" + urlStr);
            HttpClient client = new HttpClient();
            GetMethod method = new GetMethod(urlStr);
            HttpClientParams params = new HttpClientParams();
            params.setConnectionManagerTimeout(3000L);
            params.setSoTimeout(3000);
            client.setParams(params);
            client.executeMethod(method);
            byte[] responseBody = method.getResponseBody();
            if (responseBody == null) {
                boolean bl = test = false;
                return bl;
            }
            try {
                String content = new String(responseBody, "utf-8");
                ObjectMapper mapper = new ObjectMapper();
                Map dataMap = mapper.readValue(content, HashMap.class);
                if ("Y".equals(dataMap.get("success"))) {
                    test = true;
                }
            }
            catch (JsonParseException e) {
                logger.error(e.getMessage().toString());
            }
            catch (JsonMappingException e) {
                logger.error(e.getMessage().toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            if (!test) {
                logger.warn("checkTestConnection : " + String.valueOf(test));
            } else {
                logger.info("checkTestConnection : " + String.valueOf(test));
            }
        }
        return test;
    }

    public static boolean checkLoginUrlWithAllSysHostConfig(HttpServletRequest request) {
        boolean pathSuccess = true;
        ISysService sysService = (ISysService)AppContext.getBean("core.service.SysService");
        try {
            List sysList = sysService.findListByParams(null);
            int i = 0;
            while (sysList != null && i < sysList.size() && pathSuccess) {
                TbSys sys = (TbSys)sysList.get(i);
                boolean bl = pathSuccess = !ApplicationSiteUtils.checkCrossSite(sys.getHost().toLowerCase(), request);
                if (pathSuccess) {
                    pathSuccess = ApplicationSiteUtils.checkTestConnection(sys.getHost(), sys.getContextPath(), request);
                }
                ++i;
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pathSuccess;
    }

    public static List<SysVO> getSystemsCheckCrossSiteWithTestConnection(HttpServletRequest request) {
        ISysService sysService = (ISysService)AppContext.getBean("core.service.SysService");
        List<SysVO> sysList = null;
        try {
            sysList = sysService.findListVOByParams(null);
            for (SysVO sys : sysList) {
                if (ApplicationSiteUtils.checkCrossSite(sys.getHost().toLowerCase(), request)) {
                    sys.setCrossSiteFlag("Y");
                } else {
                    sys.setCrossSiteFlag("N");
                }
                if (ApplicationSiteUtils.checkTestConnection(sys.getHost(), sys.getContextPath(), request)) {
                    sys.setTestFlag("Y");
                    continue;
                }
                sys.setTestFlag("N");
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sysList;
    }
}

