/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.sys;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.util.SimpleUtils;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class SysEventLogSupport {
    protected static Logger log = Logger.getLogger(SysEventLogSupport.class);

    public static void log(String userId, String sysId, String executeEventId, boolean permit) {
        if (StringUtils.isBlank(userId) || StringUtils.isBlank(sysId) || StringUtils.isBlank(executeEventId)) {
            log.warn("null userId=" + userId + ", sysId=" + sysId + ", executeEventId=" + executeEventId);
            return;
        }
        if (executeEventId.indexOf("commomLoadForm.action") > -1) {
            log.warn("Common load form no need event log : " + executeEventId + " , permit = " + permit);
            return;
        }
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = (NamedParameterJdbcTemplate)AppContext.getBean("namedParameterJdbcTemplate");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("oid", SimpleUtils.getUUIDStr());
        paramMap.put("user", userId);
        paramMap.put("sysId", sysId);
        paramMap.put("executeEvent", executeEventId.length() > 255 ? executeEventId.substring(0, 255) : executeEventId);
        paramMap.put("isPermit", permit ? "Y" : "N");
        paramMap.put("cuserid", "SYS");
        paramMap.put("cdate", new Date());
        try {
            namedParameterJdbcTemplate.update("insert into tb_sys_event_log(OID, USER, SYS_ID, EXECUTE_EVENT, IS_PERMIT, CUSERID, CDATE) values(:oid, :user, :sysId, :executeEvent, :isPermit, :cuserid, :cdate)", paramMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage().toString());
        }
    }
}

