/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.sys;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.po.hbm.TbAccount;
import com.netsteadfast.greenstep.service.IAccountService;
import com.netsteadfast.greenstep.sys.GreenStepBaseUsernamePasswordToken;
import com.netsteadfast.greenstep.sys.InvalidAccountException;
import com.netsteadfast.greenstep.vo.AccountVO;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class ShiroLoginSupport {
    protected Logger logger = Logger.getLogger(ShiroLoginSupport.class);
    private IAccountService<AccountVO, TbAccount, String> accountService;

    public ShiroLoginSupport() {
        try {
            this.initServiceBeans();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initServiceBeans() throws Exception {
        this.accountService = (IAccountService)AppContext.getBean("core.service.AccountService");
    }

    public IAccountService<AccountVO, TbAccount, String> getAccountService() {
        return this.accountService;
    }

    public void setAccountService(IAccountService<AccountVO, TbAccount, String> accountService) {
        this.accountService = accountService;
    }

    protected Subject getSubject(ServletRequest request, ServletResponse response) {
        return SecurityUtils.getSubject();
    }

    public Subject forceCreateLoginSubject(HttpServletRequest request, HttpServletResponse response, String accountId, String captchaStr) throws Exception {
        AccountVO account = this.queryUser(accountId);
        if (account == null) {
            this.logger.warn("no accountId: " + accountId);
            throw new Exception("no accountId: " + accountId);
        }
        request.getSession().setAttribute("captcha", (Object)captchaStr);
        GreenStepBaseUsernamePasswordToken token = new GreenStepBaseUsernamePasswordToken();
        token.setCaptcha(captchaStr);
        token.setUsername(account.getAccount());
        token.setPassword(account.getPassword().toCharArray());
        Subject subject = this.getSubject((ServletRequest)request, (ServletResponse)response);
        subject.login(token);
        return subject;
    }

    public Subject forceCreateLoginSubject(String accountId) throws Exception {
        AccountVO account = this.queryUser(accountId);
        if (account == null) {
            this.logger.warn("no accountId: " + accountId);
            throw new Exception("no accountId: " + accountId);
        }
        Subject subject = SecurityUtils.getSubject();
        GreenStepBaseUsernamePasswordToken token = new GreenStepBaseUsernamePasswordToken();
        token.setCaptcha("0123");
        token.setUsername(account.getAccount());
        token.setPassword(account.getPassword().toCharArray());
        subject.login(token);
        return subject;
    }

    public AccountVO queryUserValidate(String account) throws Exception {
        AccountVO accountObj = this.queryUser(account);
        this.userValidate(accountObj);
        return accountObj;
    }

    public AccountVO queryUser(String account) throws Exception {
        if (StringUtils.isBlank(account)) {
            return null;
        }
        if (this.accountService == null) {
            this.logger.error("no service bean: core.service.AccountService");
            throw new Exception("no service bean: core.service.AccountService");
        }
        AccountVO accountObj = new AccountVO();
        accountObj.setAccount(account);
        DefaultResult<AccountVO> result = this.accountService.findByUK(accountObj);
        if (result.getValue() == null) {
            return null;
        }
        accountObj = result.getValue();
        return accountObj;
    }

    private void userValidate(AccountVO account) throws Exception {
        if (account == null) {
            return;
        }
        if (!"Y".equals(account.getOnJob())) {
            throw new InvalidAccountException("Invalid account!");
        }
    }
}

