/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.sys;

import com.netsteadfast.greenstep.sys.GreenStepHessianUtils;
import com.netsteadfast.greenstep.sys.ShiroLoginSupport;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.shiro.subject.Subject;
import org.springframework.remoting.caucho.HessianServiceExporter;

public class GreenStepHessianServiceExporter
extends HessianServiceExporter {
    protected Logger logger = Logger.getLogger(GreenStepHessianServiceExporter.class);

    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!GreenStepHessianUtils.getConfigHessianHeaderCheckValueModeEnable()) {
            super.handleRequest(request, response);
            return;
        }
        String checkValue = GreenStepHessianUtils.getHttpRequestHeaderCheckValue(request);
        Map<String, String> dataMap = null;
        try {
            dataMap = GreenStepHessianUtils.getDecAuthValue(checkValue);
            if (dataMap == null || !GreenStepHessianUtils.isCheckValue(dataMap)) {
                this.logger.warn("fail check value hessian webService");
                return;
            }
            String userId = GreenStepHessianUtils.getUserId(dataMap);
            if (StringUtils.isBlank(userId)) {
                this.logger.warn("no userId cannot access hessian webService");
                return;
            }
            if (GreenStepHessianUtils.isProxyBlockedAccountId(userId)) {
                this.logger.warn("blocked userId: " + userId + " cannot access hessian webService");
                return;
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage().toString());
            e.printStackTrace();
            return;
        }
        Subject subject = null;
        try {
            try {
                ShiroLoginSupport loginSupport = new ShiroLoginSupport();
                subject = loginSupport.forceCreateLoginSubject(request, response, GreenStepHessianUtils.getUserId(dataMap), "0123");
                super.handleRequest(request, response);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage().toString());
                e.printStackTrace();
                if (subject != null) {
                    subject.logout();
                }
            }
        }
        finally {
            if (subject != null) {
                subject.logout();
            }
        }
    }
}

