/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.service.logic.BaseLogicService;
import com.netsteadfast.greenstep.po.hbm.TbSysJreport;
import com.netsteadfast.greenstep.po.hbm.TbSysJreportParam;
import com.netsteadfast.greenstep.service.ISysJreportParamService;
import com.netsteadfast.greenstep.service.ISysJreportService;
import com.netsteadfast.greenstep.service.logic.ISystemJreportLogicService;
import com.netsteadfast.greenstep.vo.SysJreportParamVO;
import com.netsteadfast.greenstep.vo.SysJreportVO;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="core.service.logic.SystemJreportLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class SystemJreportLogicServiceImpl
extends BaseLogicService
implements ISystemJreportLogicService {
    protected Logger logger = Logger.getLogger(SystemJreportLogicServiceImpl.class);
    private static final int MAX_DESCRIPTION_LENGTH = 500;
    private ISysJreportService<SysJreportVO, TbSysJreport, String> sysJreportService;
    private ISysJreportParamService<SysJreportParamVO, TbSysJreportParam, String> sysJreportParamService;

    public ISysJreportService<SysJreportVO, TbSysJreport, String> getSysJreportService() {
        return this.sysJreportService;
    }

    @Autowired
    @Resource(name="core.service.SysJreportService")
    @Required
    public void setSysJreportService(ISysJreportService<SysJreportVO, TbSysJreport, String> sysJreportService) {
        this.sysJreportService = sysJreportService;
    }

    public ISysJreportParamService<SysJreportParamVO, TbSysJreportParam, String> getSysJreportParamService() {
        return this.sysJreportParamService;
    }

    @Autowired
    @Resource(name="core.service.SysJreportParamService")
    @Required
    public void setSysJreportParamService(ISysJreportParamService<SysJreportParamVO, TbSysJreportParam, String> sysJreportParamService) {
        this.sysJreportParamService = sysJreportParamService;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysJreportVO> create(SysJreportVO report) throws ServiceException, Exception {
        if (report == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        if (super.defaultString(report.getDescription()).length() > 500) {
            report.setDescription(report.getDescription().substring(0, 500));
        }
        if ("Y".equals(report.getIsCompile())) {
            report.setFile(String.valueOf(report.getReportId()) + ".jrxml");
        } else {
            report.setFile(String.valueOf(report.getReportId()) + ".jasper");
        }
        return this.sysJreportService.saveObject(report);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysJreportVO> update(SysJreportVO report) throws ServiceException, Exception {
        if (report == null || super.isBlank(report.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<SysJreportVO> oldResult = this.sysJreportService.findObjectByOid(report);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        report.setReportId(oldResult.getValue().getReportId());
        byte[] content = oldResult.getValue().getContent();
        oldResult.getValue().setContent(null);
        this.sysJreportService.updateObject(oldResult.getValue());
        if (super.defaultString(report.getDescription()).length() > 500) {
            report.setDescription(report.getDescription().substring(0, 500));
        }
        if (report.getContent() == null) {
            report.setContent(content);
        }
        if ("Y".equals(report.getIsCompile())) {
            report.setFile(String.valueOf(report.getReportId()) + ".jrxml");
        } else {
            report.setFile(String.valueOf(report.getReportId()) + ".jasper");
        }
        return this.sysJreportService.updateObject(report);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> delete(SysJreportVO report) throws ServiceException, Exception {
        if (report == null || super.isBlank(report.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<SysJreportVO> mResult = this.sysJreportService.findForSimple(report.getOid());
        if (mResult.getValue() == null) {
            throw new ServiceException(mResult.getSystemMessage().getValue());
        }
        report = mResult.getValue();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("reportId", report.getReportId());
        List searchList = this.sysJreportParamService.findListByParams(params);
        int i = 0;
        while (searchList != null && i < searchList.size()) {
            this.sysJreportParamService.delete((TbSysJreportParam)searchList.get(i));
            ++i;
        }
        return this.sysJreportService.deleteObject(report);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysJreportParamVO> createParam(SysJreportParamVO reportParam, String reportOid) throws ServiceException, Exception {
        if (reportParam == null || super.isBlank(reportOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<SysJreportVO> mResult = this.sysJreportService.findForSimple(reportOid);
        if (mResult.getValue() == null) {
            throw new ServiceException(mResult.getSystemMessage().getValue());
        }
        SysJreportVO report = mResult.getValue();
        reportParam.setReportId(report.getReportId());
        return this.sysJreportParamService.saveObject(reportParam);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> deleteParam(SysJreportParamVO reportParam) throws ServiceException, Exception {
        if (reportParam == null || super.isBlank(reportParam.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.sysJreportParamService.deleteObject(reportParam);
    }
}

