/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.service.logic.BaseLogicService;
import com.netsteadfast.greenstep.po.hbm.TbSys;
import com.netsteadfast.greenstep.po.hbm.TbSysBeanHelpExpr;
import com.netsteadfast.greenstep.po.hbm.TbSysExprJob;
import com.netsteadfast.greenstep.po.hbm.TbSysExpression;
import com.netsteadfast.greenstep.service.ISysBeanHelpExprService;
import com.netsteadfast.greenstep.service.ISysExprJobService;
import com.netsteadfast.greenstep.service.ISysExpressionService;
import com.netsteadfast.greenstep.service.ISysService;
import com.netsteadfast.greenstep.service.logic.ISystemExpressionLogicService;
import com.netsteadfast.greenstep.vo.SysBeanHelpExprVO;
import com.netsteadfast.greenstep.vo.SysExprJobVO;
import com.netsteadfast.greenstep.vo.SysExpressionVO;
import com.netsteadfast.greenstep.vo.SysVO;
import java.io.IOException;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="core.service.logic.SystemExpressionLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class SystemExpressionLogicServiceImpl
extends BaseLogicService
implements ISystemExpressionLogicService {
    protected Logger logger = Logger.getLogger(SystemExpressionLogicServiceImpl.class);
    private static final int MAX_CONTENT_LENGTH = 8000;
    private static final int MAX_DESCRIPTION_LENGTH = 500;
    private ISysExpressionService<SysExpressionVO, TbSysExpression, String> sysExpressionService;
    private ISysBeanHelpExprService<SysBeanHelpExprVO, TbSysBeanHelpExpr, String> sysBeanHelpExprService;
    private ISysExprJobService<SysExprJobVO, TbSysExprJob, String> sysExprJobService;
    private ISysService<SysVO, TbSys, String> sysService;

    public ISysExpressionService<SysExpressionVO, TbSysExpression, String> getSysExpressionService() {
        return this.sysExpressionService;
    }

    @Autowired
    @Resource(name="core.service.SysExpressionService")
    @Required
    public void setSysExpressionService(ISysExpressionService<SysExpressionVO, TbSysExpression, String> sysExpressionService) {
        this.sysExpressionService = sysExpressionService;
    }

    public ISysBeanHelpExprService<SysBeanHelpExprVO, TbSysBeanHelpExpr, String> getSysBeanHelpExprService() {
        return this.sysBeanHelpExprService;
    }

    @Autowired
    @Resource(name="core.service.SysBeanHelpExprService")
    @Required
    public void setSysBeanHelpExprService(ISysBeanHelpExprService<SysBeanHelpExprVO, TbSysBeanHelpExpr, String> sysBeanHelpExprService) {
        this.sysBeanHelpExprService = sysBeanHelpExprService;
    }

    public ISysExprJobService<SysExprJobVO, TbSysExprJob, String> getSysExprJobService() {
        return this.sysExprJobService;
    }

    @Autowired
    @Resource(name="core.service.SysExprJobService")
    @Required
    public void setSysExprJobService(ISysExprJobService<SysExprJobVO, TbSysExprJob, String> sysExprJobService) {
        this.sysExprJobService = sysExprJobService;
    }

    public ISysService<SysVO, TbSys, String> getSysService() {
        return this.sysService;
    }

    @Autowired
    @Resource(name="core.service.SysService")
    @Required
    public void setSysService(ISysService<SysVO, TbSys, String> sysService) {
        this.sysService = sysService;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysExpressionVO> create(SysExpressionVO expression) throws ServiceException, Exception {
        if (expression == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        if (super.defaultString(expression.getContent()).length() > 8000) {
            throw new ServiceException("Expression only 8,000 words!");
        }
        if (super.defaultString(expression.getDescription()).length() > 500) {
            expression.setDescription(expression.getDescription().substring(0, 500));
        }
        return this.sysExpressionService.saveObject(expression);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysExpressionVO> update(SysExpressionVO expression) throws ServiceException, Exception {
        DefaultResult<SysExpressionVO> oldResult;
        if (expression == null || super.isBlank(expression.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        if (super.defaultString(expression.getContent()).length() > 8000) {
            throw new ServiceException("Expression only 8,000 words!");
        }
        if (super.defaultString(expression.getDescription()).length() > 500) {
            expression.setDescription(expression.getDescription().substring(0, 500));
        }
        if ((oldResult = this.sysExpressionService.findObjectByOid(expression)).getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        expression.setExprId(oldResult.getValue().getExprId());
        return this.sysExpressionService.updateObject(expression);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> delete(SysExpressionVO expression) throws ServiceException, Exception {
        if (expression == null || super.isBlank(expression.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<SysExpressionVO> oldResult = this.sysExpressionService.findObjectByOid(expression);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("exprId", oldResult.getValue().getExprId());
        if (this.sysBeanHelpExprService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        if (this.sysExprJobService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        return this.sysExpressionService.deleteObject(expression);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysExprJobVO> createJob(SysExprJobVO exprJob, String systemOid, String expressionOid) throws ServiceException, Exception {
        if (exprJob == null || super.isBlank(systemOid) || super.isBlank(expressionOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysVO sys = new SysVO();
        sys.setOid(systemOid);
        DefaultResult<SysVO> sysResult = this.sysService.findObjectByOid(sys);
        if (sysResult.getValue() == null) {
            throw new ServiceException(sysResult.getSystemMessage().getValue());
        }
        sys = sysResult.getValue();
        SysExpressionVO expression = new SysExpressionVO();
        expression.setOid(expressionOid);
        DefaultResult<SysExpressionVO> expressionResult = this.sysExpressionService.findObjectByOid(expression);
        if (expressionResult.getValue() == null) {
            throw new ServiceException(expressionResult.getSystemMessage().getValue());
        }
        expression = expressionResult.getValue();
        exprJob.setSystem(sys.getSysId());
        exprJob.setExprId(expression.getExprId());
        exprJob.setRunStatus("Y");
        this.setStringValueMaxLength(exprJob, "description", 500);
        return this.sysExprJobService.saveObject(exprJob);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysExprJobVO> updateJob(SysExprJobVO exprJob, String systemOid, String expressionOid) throws ServiceException, Exception {
        if (exprJob == null || StringUtils.isBlank(exprJob.getOid()) || StringUtils.isBlank(systemOid) || StringUtils.isBlank(expressionOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysVO sys = new SysVO();
        sys.setOid(systemOid);
        DefaultResult<SysVO> sysResult = this.sysService.findObjectByOid(sys);
        if (sysResult.getValue() == null) {
            throw new ServiceException(sysResult.getSystemMessage().getValue());
        }
        sys = sysResult.getValue();
        SysExpressionVO expression = new SysExpressionVO();
        expression.setOid(expressionOid);
        DefaultResult<SysExpressionVO> expressionResult = this.sysExpressionService.findObjectByOid(expression);
        if (expressionResult.getValue() == null) {
            throw new ServiceException(expressionResult.getSystemMessage().getValue());
        }
        expression = expressionResult.getValue();
        DefaultResult<SysExprJobVO> oldResult = this.sysExprJobService.findObjectByOid(exprJob);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        exprJob.setId(oldResult.getValue().getId());
        exprJob.setSystem(sys.getSysId());
        exprJob.setExprId(expression.getExprId());
        exprJob.setRunStatus(oldResult.getValue().getRunStatus());
        if (super.isBlank(oldResult.getValue().getRunStatus())) {
            exprJob.setRunStatus("F");
            this.logger.warn("Before runStatus flag is blank. Expression Job ID: " + oldResult.getValue().getId());
        }
        this.setStringValueMaxLength(exprJob, "description", 500);
        return this.sysExprJobService.updateObject(exprJob);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> deleteJob(SysExprJobVO exprJob) throws ServiceException, Exception {
        if (exprJob == null || StringUtils.isBlank(exprJob.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<SysExprJobVO> oldResult = this.sysExprJobService.findObjectByOid(exprJob);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        exprJob = oldResult.getValue();
        return this.sysExprJobService.deleteObject(exprJob);
    }
}

