/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.service.logic.BaseLogicService;
import com.netsteadfast.greenstep.po.hbm.TbSys;
import com.netsteadfast.greenstep.po.hbm.TbSysCtxBean;
import com.netsteadfast.greenstep.service.ISysCtxBeanService;
import com.netsteadfast.greenstep.service.ISysService;
import com.netsteadfast.greenstep.service.logic.ISystemContextBeanLogicService;
import com.netsteadfast.greenstep.vo.SysCtxBeanVO;
import com.netsteadfast.greenstep.vo.SysVO;
import java.io.IOException;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="core.service.logic.SystemContextBeanLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class SystemContextBeanLogicServiceImpl
extends BaseLogicService
implements ISystemContextBeanLogicService {
    protected Logger logger = Logger.getLogger(SystemContextBeanLogicServiceImpl.class);
    private static final int MAX_DESCRIPTION_LENGTH = 500;
    private ISysCtxBeanService<SysCtxBeanVO, TbSysCtxBean, String> sysCxtBeanService;
    private ISysService<SysVO, TbSys, String> sysService;

    public ISysCtxBeanService<SysCtxBeanVO, TbSysCtxBean, String> getSysCxtBeanService() {
        return this.sysCxtBeanService;
    }

    @Autowired
    @Resource(name="core.service.SysCtxBeanService")
    @Required
    public void setSysCxtBeanService(ISysCtxBeanService<SysCtxBeanVO, TbSysCtxBean, String> sysCxtBeanService) {
        this.sysCxtBeanService = sysCxtBeanService;
    }

    public ISysService<SysVO, TbSys, String> getSysService() {
        return this.sysService;
    }

    @Autowired
    @Resource(name="core.service.SysService")
    @Required
    public void setSysService(ISysService<SysVO, TbSys, String> sysService) {
        this.sysService = sysService;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysCtxBeanVO> create(SysCtxBeanVO ctxBean, String systemOid) throws ServiceException, Exception {
        if (ctxBean == null || super.isBlank(systemOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysVO sys = new SysVO();
        sys.setOid(systemOid);
        DefaultResult<SysVO> sResult = this.sysService.findObjectByOid(sys);
        if (sResult.getValue() == null) {
            throw new ServiceException(sResult.getSystemMessage().getValue());
        }
        sys = sResult.getValue();
        ctxBean.setSystem(sys.getSysId());
        if (super.defaultString(ctxBean.getDescription()).length() > 500) {
            ctxBean.setDescription(ctxBean.getDescription().substring(0, 500));
        }
        return this.sysCxtBeanService.saveObject(ctxBean);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysCtxBeanVO> update(SysCtxBeanVO ctxBean, String systemOid) throws ServiceException, Exception {
        if (ctxBean == null || super.isBlank(ctxBean.getOid()) || super.isBlank(systemOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysVO sys = new SysVO();
        sys.setOid(systemOid);
        DefaultResult<SysVO> sResult = this.sysService.findObjectByOid(sys);
        if (sResult.getValue() == null) {
            throw new ServiceException(sResult.getSystemMessage().getValue());
        }
        sys = sResult.getValue();
        ctxBean.setSystem(sys.getSysId());
        DefaultResult<SysCtxBeanVO> anotherResult = this.sysCxtBeanService.findByUK(ctxBean);
        if (anotherResult.getValue() != null && !anotherResult.getValue().getOid().equals(ctxBean.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0002"));
        }
        if (super.defaultString(ctxBean.getDescription()).length() > 500) {
            ctxBean.setDescription(ctxBean.getDescription().substring(0, 500));
        }
        return this.sysCxtBeanService.updateObject(ctxBean);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> delete(SysCtxBeanVO ctxBean) throws ServiceException, Exception {
        if (ctxBean == null || super.isBlank(ctxBean.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.sysCxtBeanService.deleteObject(ctxBean);
    }
}

