/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.service.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.dao.IBaseDAO;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.PageOf;
import com.netsteadfast.greenstep.base.model.QueryResult;
import com.netsteadfast.greenstep.base.model.SearchValue;
import com.netsteadfast.greenstep.base.service.BaseService;
import com.netsteadfast.greenstep.dao.ISysProgDAO;
import com.netsteadfast.greenstep.po.hbm.TbSysProg;
import com.netsteadfast.greenstep.service.ISysProgService;
import com.netsteadfast.greenstep.util.IconUtils;
import com.netsteadfast.greenstep.vo.SysProgVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="core.service.SysProgService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class SysProgServiceImpl
extends BaseService<SysProgVO, TbSysProg, String>
implements ISysProgService<SysProgVO, TbSysProg, String> {
    protected Logger logger = Logger.getLogger(SysProgServiceImpl.class);
    private ISysProgDAO<TbSysProg, String> sysProgDAO;

    public ISysProgDAO<TbSysProg, String> getSysProgDAO() {
        return this.sysProgDAO;
    }

    @Autowired
    @Resource(name="core.dao.SysProgDAO")
    @Required
    public void setSysProgDAO(ISysProgDAO<TbSysProg, String> sysProgDAO) {
        this.sysProgDAO = sysProgDAO;
    }

    @Override
    protected IBaseDAO<TbSysProg, String> getBaseDataAccessObject() {
        return this.sysProgDAO;
    }

    @Override
    public String getMapperIdPo2Vo() {
        return "sysProg.po2vo";
    }

    @Override
    public String getMapperIdVo2Po() {
        return "sysProg.vo2po";
    }

    @Override
    public String findNameForProgId(String progId) throws ServiceException, Exception {
        if (StringUtils.isBlank(progId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysProgVO sysProg = this.sysProgDAO.findNameForProgId(progId);
        if (sysProg == null) {
            return "";
        }
        return super.defaultString(sysProg.getName());
    }

    private Map<String, Object> getQueryGridParameter(SearchValue searchValue) throws Exception {
        return super.getQueryParamHandler(searchValue).containingLike("name").fullEquals4TextField("progId").getValue();
    }

    @Override
    public QueryResult<List<SysProgVO>> findGridResult(SearchValue searchValue, PageOf pageOf) throws ServiceException, Exception {
        if (searchValue == null || pageOf == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0009"));
        }
        Map<String, Object> params = this.getQueryGridParameter(searchValue);
        int limit = Integer.parseInt(pageOf.getShowRow());
        int offset = (Integer.parseInt(pageOf.getSelect()) - 1) * limit;
        QueryResult<List<SysProgVO>> result = this.sysProgDAO.findPageQueryResultByQueryName("findSysProgPageGrid", params, offset, limit);
        pageOf.setCountSize(String.valueOf(result.getRowCount()));
        pageOf.toCalculateSize();
        return result;
    }

    @Override
    public Map<String, String> findSysProgFolderMap(String basePath, String progSystem, String itemType, boolean pleaseSelect) throws ServiceException, Exception {
        if (StringUtils.isBlank(progSystem)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        Map<String, String> dataMap = super.providedSelectZeroDataMap(pleaseSelect);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("progSystem", progSystem);
        params.put("itemType", itemType);
        List searchList = this.findListByParams(params);
        if (searchList == null || searchList.size() < 1) {
            return dataMap;
        }
        for (TbSysProg sysProg : searchList) {
            dataMap.put(sysProg.getOid(), String.valueOf(IconUtils.getMenuIcon(basePath, sysProg.getIcon())) + sysProg.getName());
        }
        return dataMap;
    }

    @Override
    public List<SysProgVO> findForInTheFolderMenuItems(String progSystem, String menuParentOid, String itemType) throws ServiceException, Exception {
        if (StringUtils.isBlank(progSystem)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.getSysProgDAO().findForInTheFolderMenuItems(progSystem, menuParentOid, itemType);
    }

    @Override
    public List<SysProgVO> findForSystemItems(String progSystem) throws ServiceException, Exception {
        if (StringUtils.isBlank(progSystem)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.getSysProgDAO().findForSystemItems(progSystem);
    }
}

