/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.service.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.dao.IBaseDAO;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.service.BaseService;
import com.netsteadfast.greenstep.dao.ISysMailHelperDAO;
import com.netsteadfast.greenstep.po.hbm.TbSysMailHelper;
import com.netsteadfast.greenstep.service.ISysMailHelperService;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.vo.SysMailHelperVO;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="core.service.SysMailHelperService")
@Scope(value="prototype")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class SysMailHelperServiceImpl
extends BaseService<SysMailHelperVO, TbSysMailHelper, String>
implements ISysMailHelperService<SysMailHelperVO, TbSysMailHelper, String> {
    protected Logger logger = Logger.getLogger(SysMailHelperServiceImpl.class);
    private ISysMailHelperDAO<TbSysMailHelper, String> sysMailHelperDAO;

    public ISysMailHelperDAO<TbSysMailHelper, String> getSysMailHelperDAO() {
        return this.sysMailHelperDAO;
    }

    @Autowired
    @Resource(name="core.dao.SysMailHelperDAO")
    @Required
    public void setSysMailHelperDAO(ISysMailHelperDAO<TbSysMailHelper, String> sysMailHelperDAO) {
        this.sysMailHelperDAO = sysMailHelperDAO;
    }

    @Override
    protected IBaseDAO<TbSysMailHelper, String> getBaseDataAccessObject() {
        return this.sysMailHelperDAO;
    }

    @Override
    public String getMapperIdPo2Vo() {
        return "sysMailHelper.po2vo";
    }

    @Override
    public String getMapperIdVo2Po() {
        return "sysMailHelper.vo2po";
    }

    @Override
    public DefaultResult<List<TbSysMailHelper>> findForJobList(String mailId, String successFlag) throws ServiceException, Exception {
        if (StringUtils.isBlank(mailId) || StringUtils.isBlank(successFlag)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<List<TbSysMailHelper>> result = new DefaultResult<List<TbSysMailHelper>>();
        List<TbSysMailHelper> searchList = this.sysMailHelperDAO.findForJobList(mailId, successFlag);
        if (searchList != null && searchList.size() > 0) {
            result.setValue(searchList);
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0009")));
        }
        return result;
    }

    @Override
    public String findForMaxMailId(String mailId) throws ServiceException, Exception {
        if (StringUtils.isBlank(mailId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.sysMailHelperDAO.findForMaxMailId(mailId);
    }

    @Override
    public String findForMaxMailIdComplete(String mailId) throws ServiceException, Exception {
        if (StringUtils.isBlank(mailId) || !SimpleUtils.isDate(mailId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        String maxMailId = this.findForMaxMailId(mailId);
        if (StringUtils.isBlank(maxMailId)) {
            return String.valueOf(mailId) + "000000001";
        }
        int maxSeq = Integer.parseInt(maxMailId.substring(8, 17)) + 1;
        if (maxSeq > 999999999) {
            throw new ServiceException(String.valueOf(SysMessageUtil.get("MSG_STD0005")) + " over max mail-id 999999999!");
        }
        return String.valueOf(mailId) + StringUtils.leftPad(String.valueOf(maxSeq), 9, "0");
    }
}

