/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.service.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.dao.IBaseDAO;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.PageOf;
import com.netsteadfast.greenstep.base.model.QueryResult;
import com.netsteadfast.greenstep.base.model.SearchValue;
import com.netsteadfast.greenstep.base.service.BaseService;
import com.netsteadfast.greenstep.dao.ISysExpressionDAO;
import com.netsteadfast.greenstep.po.hbm.TbSysExpression;
import com.netsteadfast.greenstep.service.ISysExpressionService;
import com.netsteadfast.greenstep.vo.SysExpressionVO;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="core.service.SysExpressionService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class SysExpressionServiceImpl
extends BaseService<SysExpressionVO, TbSysExpression, String>
implements ISysExpressionService<SysExpressionVO, TbSysExpression, String> {
    protected Logger logger = Logger.getLogger(SysExpressionServiceImpl.class);
    private ISysExpressionDAO<TbSysExpression, String> sysExpressionDAO;

    public ISysExpressionDAO<TbSysExpression, String> getSysExpressionDAO() {
        return this.sysExpressionDAO;
    }

    @Autowired
    @Resource(name="core.dao.SysExpressionDAO")
    @Required
    public void setSysExpressionDAO(ISysExpressionDAO<TbSysExpression, String> sysExpressionDAO) {
        this.sysExpressionDAO = sysExpressionDAO;
    }

    @Override
    protected IBaseDAO<TbSysExpression, String> getBaseDataAccessObject() {
        return this.sysExpressionDAO;
    }

    @Override
    public String getMapperIdPo2Vo() {
        return "sysExpression.po2vo";
    }

    @Override
    public String getMapperIdVo2Po() {
        return "sysExpression.vo2po";
    }

    private Map<String, Object> getQueryGridParameter(SearchValue searchValue) throws Exception {
        return super.getQueryParamHandler(searchValue).fullEquals4TextField("exprId").containingLike("name").fullEquals4Select("type").getValue();
    }

    @Override
    public QueryResult<List<SysExpressionVO>> findGridResult(SearchValue searchValue, PageOf pageOf) throws ServiceException, Exception {
        if (searchValue == null || pageOf == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0009"));
        }
        Map<String, Object> params = this.getQueryGridParameter(searchValue);
        int limit = Integer.parseInt(pageOf.getShowRow());
        int offset = (Integer.parseInt(pageOf.getSelect()) - 1) * limit;
        QueryResult<List<SysExpressionVO>> result = this.sysExpressionDAO.findPageQueryResultByQueryName("findSysExpressionPageGrid", params, offset, limit);
        pageOf.setCountSize(String.valueOf(result.getRowCount()));
        pageOf.toCalculateSize();
        return result;
    }

    @Override
    public Map<String, String> findExpressionMap(boolean pleaseSelect) throws ServiceException, Exception {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        if (pleaseSelect) {
            dataMap.put("all", " - please select - ");
        }
        List<SysExpressionVO> searchList = this.sysExpressionDAO.findListForSimple();
        int i = 0;
        while (searchList != null && i < searchList.size()) {
            SysExpressionVO expression = searchList.get(i);
            dataMap.put(expression.getOid(), String.valueOf(expression.getExprId()) + " - " + expression.getName());
            ++i;
        }
        return dataMap;
    }

    @Override
    @Cacheable(value={"default"}, key="#sysExpression.exprId")
    public DefaultResult<SysExpressionVO> findByUkCacheable(SysExpressionVO sysExpression) throws ServiceException, Exception {
        return this.findByUK(sysExpression);
    }
}

