/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.service.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.dao.IBaseDAO;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.PageOf;
import com.netsteadfast.greenstep.base.model.QueryResult;
import com.netsteadfast.greenstep.base.model.SearchValue;
import com.netsteadfast.greenstep.base.service.BaseService;
import com.netsteadfast.greenstep.dao.IRolePermissionDAO;
import com.netsteadfast.greenstep.po.hbm.TbRolePermission;
import com.netsteadfast.greenstep.service.IRolePermissionService;
import com.netsteadfast.greenstep.vo.RolePermissionVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="core.service.RolePermissionService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class RolePermissionServiceImpl
extends BaseService<RolePermissionVO, TbRolePermission, String>
implements IRolePermissionService<RolePermissionVO, TbRolePermission, String> {
    protected Logger logger = Logger.getLogger(RolePermissionServiceImpl.class);
    private IRolePermissionDAO<TbRolePermission, String> rolePermissionDAO;

    public IRolePermissionDAO<TbRolePermission, String> getRolePermissionDAO() {
        return this.rolePermissionDAO;
    }

    @Autowired
    @Resource(name="core.dao.RolePermissionDAO")
    @Required
    public void setRolePermissionDAO(IRolePermissionDAO<TbRolePermission, String> rolePermissionDAO) {
        this.rolePermissionDAO = rolePermissionDAO;
    }

    @Override
    protected IBaseDAO<TbRolePermission, String> getBaseDataAccessObject() {
        return this.rolePermissionDAO;
    }

    @Override
    public String getMapperIdPo2Vo() {
        return "rolePermission.po2vo";
    }

    @Override
    public String getMapperIdVo2Po() {
        return "rolePermission.vo2po";
    }

    private Map<String, Object> getQueryParameters(SearchValue searchValue) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String role = searchValue.getParameter().get("role");
        if (!StringUtils.isBlank(role)) {
            params.put("role", role);
        }
        return params;
    }

    @Override
    public QueryResult<List<RolePermissionVO>> findGridResult(SearchValue searchValue, PageOf pageOf) throws ServiceException, Exception {
        if (searchValue == null || pageOf == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0009"));
        }
        Map<String, Object> params = this.getQueryParameters(searchValue);
        int limit = Integer.parseInt(pageOf.getShowRow());
        int offset = (Integer.parseInt(pageOf.getSelect()) - 1) * limit;
        QueryResult<List<RolePermissionVO>> result = this.rolePermissionDAO.findPageQueryResultByQueryName("findRolePermissionPageGrid", params, offset, limit);
        pageOf.setCountSize(String.valueOf(result.getRowCount()));
        pageOf.toCalculateSize();
        return result;
    }
}

