/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.service.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.dao.IBaseDAO;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.service.BaseService;
import com.netsteadfast.greenstep.dao.IAccountDAO;
import com.netsteadfast.greenstep.po.hbm.TbAccount;
import com.netsteadfast.greenstep.service.IAccountService;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.vo.AccountVO;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="core.service.AccountService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class AccountServiceImpl
extends BaseService<AccountVO, TbAccount, String>
implements IAccountService<AccountVO, TbAccount, String> {
    protected Logger logger = Logger.getLogger(AccountServiceImpl.class);
    private IAccountDAO<TbAccount, String> accountDAO;

    public IAccountDAO<TbAccount, String> getAccountDAO() {
        return this.accountDAO;
    }

    @Autowired
    @Resource(name="core.dao.AccountDAO")
    @Required
    public void setAccountDAO(IAccountDAO<TbAccount, String> accountDAO) {
        this.accountDAO = accountDAO;
    }

    @Override
    protected IBaseDAO<TbAccount, String> getBaseDataAccessObject() {
        return this.accountDAO;
    }

    @Override
    public String getMapperIdPo2Vo() {
        return "account.po2vo";
    }

    @Override
    public String getMapperIdVo2Po() {
        return "account.vo2po";
    }

    @Override
    public List<AccountVO> findForAll() throws ServiceException, Exception {
        return this.accountDAO.findForAll();
    }

    @Override
    public Map<String, String> findForAllMap(boolean pleaseSelect) throws ServiceException, Exception {
        List<AccountVO> searchList = this.findForAll();
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        if (pleaseSelect) {
            dataMap.put("all", " - please select - ");
        }
        if (searchList == null || searchList.size() < 1) {
            return dataMap;
        }
        for (AccountVO account : searchList) {
            dataMap.put(account.getOid(), account.getAccount());
        }
        return dataMap;
    }

    @Override
    public String tranPassword(String password) throws Exception {
        return SimpleUtils.toMD5Hex(SimpleUtils.toB64(password));
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public String generateNewPassword(String account) throws ServiceException, Exception {
        if (StringUtils.isBlank(account)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        TbAccount entity = new TbAccount();
        entity.setAccount(account);
        entity = this.findByEntityUK(entity);
        if (entity == null || StringUtils.isBlank(entity.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0001"));
        }
        String newPasswordStr = SimpleUtils.createRandomString(5);
        entity.setPassword(this.tranPassword(newPasswordStr));
        this.update(entity);
        return newPasswordStr;
    }
}

