/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.job.impl;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.job.BaseJob;
import com.netsteadfast.greenstep.po.hbm.TbSysMailHelper;
import com.netsteadfast.greenstep.service.ISysMailHelperService;
import com.netsteadfast.greenstep.util.MailClientUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.vo.SysMailHelperVO;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.mail.MailException;
import org.springframework.web.context.ContextLoader;

@DisallowConcurrentExecution
public class SendMailHelperJobImpl
extends BaseJob
implements Job {
    protected static Logger log = Logger.getLogger(SendMailHelperJobImpl.class);

    @Override
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        if (ContextLoader.getCurrentWebApplicationContext() == null) {
            log.warn("ApplicationContext no completed, AppContext.getApplicationContext() == null");
            return;
        }
        if (this.checkCurrentlyExecutingJobs(context, this)) {
            log.warn("Same schedule job, current working...");
            return;
        }
        try {
            try {
                this.loginForBackgroundProgram();
                ISysMailHelperService sysMailHelperService = (ISysMailHelperService)AppContext.getBean("core.service.SysMailHelperService");
                if (MailClientUtils.getEnable()) {
                    String linkMailId = SimpleUtils.getStrYMD("").substring(0, 6);
                    DefaultResult<List<TbSysMailHelper>> result = sysMailHelperService.findForJobList(linkMailId, "N");
                    if (result.getValue() != null) {
                        this.process(sysMailHelperService, result.getValue());
                    }
                } else {
                    log.warn("************ mail sender is disable. please modify config CNF/CNF_CONF002 ************");
                }
            }
            catch (ServiceException e) {
                e.printStackTrace();
                try {
                    this.logoutForBackgroundProgram();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    this.logoutForBackgroundProgram();
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                this.logoutForBackgroundProgram();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void process(ISysMailHelperService<SysMailHelperVO, TbSysMailHelper, String> sysMailHelperService, List<TbSysMailHelper> mailHelperList) throws ServiceException, Exception {
        if (mailHelperList == null || mailHelperList.size() < 1) {
            return;
        }
        for (TbSysMailHelper mailHelper : mailHelperList) {
            new ProcessWorker(sysMailHelperService, mailHelper);
        }
    }

    private class ProcessWorker
    extends Thread {
        private ISysMailHelperService<SysMailHelperVO, TbSysMailHelper, String> sysMailHelperService = null;
        private TbSysMailHelper mailHelper = null;
        private Thread flag = this;
        private long sleepTime = 3000L;
        private int rety = 3;
        private boolean success = false;

        public ProcessWorker(ISysMailHelperService<SysMailHelperVO, TbSysMailHelper, String> sysMailHelperService, TbSysMailHelper mailHelper) {
            this.sysMailHelperService = sysMailHelperService;
            this.mailHelper = mailHelper;
            this.flag = this;
            this.start();
        }

        @Override
        public void run() {
            this.flag = this;
            while (!this.success && this.flag == Thread.currentThread() && this.rety > 0) {
                if (this.mailHelper == null) {
                    this.flag = null;
                }
                try {
                    log.info("process mail-id: " + this.mailHelper.getMailId());
                    MailClientUtils.send(this.mailHelper.getMailFrom(), this.mailHelper.getMailTo(), this.mailHelper.getMailCc(), this.mailHelper.getMailBcc(), this.mailHelper.getSubject(), new String(this.mailHelper.getText(), "utf8"));
                    this.success = true;
                }
                catch (MailException e1) {
                    e1.printStackTrace();
                }
                catch (UnsupportedEncodingException e1) {
                    e1.printStackTrace();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (this.success) {
                    try {
                        if ("Y".equals(this.mailHelper.getRetainFlag())) {
                            this.mailHelper.setSuccessFlag("Y");
                            this.mailHelper.setSuccessTime(new Date());
                            this.sysMailHelperService.update(this.mailHelper);
                        } else {
                            this.sysMailHelperService.delete(this.mailHelper);
                        }
                    }
                    catch (ServiceException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    log.info("success mail-id: " + this.mailHelper.getMailId());
                    this.flag = null;
                }
                --this.rety;
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.flag = null;
            MailClientUtils.clearThreadLocal();
        }
    }
}

