/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.interceptor;

import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.sys.SysEventLogSupport;
import com.netsteadfast.greenstep.util.ControllerAuthorityCheckUtils;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.apache.struts2.ServletActionContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="greenstep.web.interceptor.ControllerAuthorityCheckInterceptor")
@Scope(value="prototype")
public class ControllerAuthorityCheckInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -8012366104374649134L;
    protected Logger logger = Logger.getLogger(ControllerAuthorityCheckInterceptor.class);

    @Override
    public String intercept(ActionInvocation actionInvocation) throws Exception {
        Method[] methods;
        String actionName = actionInvocation.getProxy().getActionName();
        String url = String.valueOf(actionName) + ".action";
        Subject subject = SecurityUtils.getSubject();
        if (subject.hasRole("*") || subject.hasRole("admin")) {
            SysEventLogSupport.log((String)subject.getPrincipal(), Constants.getSystem(), url, true);
            return actionInvocation.invoke();
        }
        Annotation[] annotations = actionInvocation.getAction().getClass().getAnnotations();
        Annotation[] actionMethodAnnotations = null;
        Method[] methodArray = methods = actionInvocation.getAction().getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (actionInvocation.getProxy().getMethod().equals(method.getName())) {
                actionMethodAnnotations = method.getAnnotations();
            }
            ++n2;
        }
        if (this.isControllerAuthority(annotations, actionMethodAnnotations, subject)) {
            SysEventLogSupport.log((String)subject.getPrincipal(), Constants.getSystem(), url, true);
            return actionInvocation.invoke();
        }
        if (subject.isPermitted(url) || subject.isPermitted("/" + url)) {
            SysEventLogSupport.log((String)subject.getPrincipal(), Constants.getSystem(), url, true);
            return actionInvocation.invoke();
        }
        this.logger.warn("[decline] user=" + subject.getPrincipal() + " url=" + url);
        String isDojoxContentPane = ServletActionContext.getRequest().getParameter("isDojoxContentPane");
        if ("Y".equals(isDojoxContentPane)) {
            SysEventLogSupport.log((String)subject.getPrincipal(), Constants.getSystem(), url, false);
            return "noAuthorith";
        }
        String header = ServletActionContext.getRequest().getHeader("X-Requested-With");
        if ("XMLHttpRequest".equalsIgnoreCase(header)) {
            PrintWriter printWriter = ServletActionContext.getResponse().getWriter();
            printWriter.print("{ \"success\":\"N\",\"message\":\"no authorize!\",\"login\":\"Y\",\"isAuthorize\":\"N\" }");
            printWriter.flush();
            printWriter.close();
            SysEventLogSupport.log((String)subject.getPrincipal(), Constants.getSystem(), url, false);
            return null;
        }
        SysEventLogSupport.log((String)subject.getPrincipal(), Constants.getSystem(), url, false);
        return "noAuthorith";
    }

    private boolean isControllerAuthority(Annotation[] actionAnnotations, Annotation[] actionMethodAnnotations, Subject subject) {
        return ControllerAuthorityCheckUtils.isControllerAuthority(actionAnnotations, actionMethodAnnotations, subject);
    }
}

