/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.aspect;

import java.lang.annotation.Annotation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;

public class AspectConstants {
    public static final String DATA_ACCESS_OBJECT_PACKAGE = " execution(* com.netsteadfast.greenstep.base.dao.*.*(..) ) || execution(* com.netsteadfast.greenstep.dao..*.*(..) ) || execution(* com.netsteadfast.greenstep.bsc.dao..*.*(..) ) || execution(* com.netsteadfast.greenstep.qcharts.dao..*.*(..) ) ";
    public static final String BASE_SERVICE_PACKAGE = " execution(* com.netsteadfast.greenstep.base.service.*.*(..) ) || execution(* com.netsteadfast.greenstep.service.*.*(..) ) || execution(* com.netsteadfast.greenstep.bsc.service.*.*(..) ) || execution(* com.netsteadfast.greenstep.qcharts.service.*.*(..) ) ";
    public static final String LOGIC_SERVICE_PACKAGE = " execution(* com.netsteadfast.greenstep.base.service.logic.*.*(..) ) || execution(* com.netsteadfast.greenstep.service.logic..*.*(..) ) || execution(* com.netsteadfast.greenstep.bsc.service.logic..*.*(..) ) || execution(* com.netsteadfast.greenstep.qcharts.service.logic..*.*(..) ) ";

    public static boolean isLogicService(String serviceId) {
        return StringUtils.defaultString(serviceId).indexOf(".service.logic.") > -1;
    }

    public static String getServiceId(Annotation[] annotations) {
        String serviceId = "";
        if (annotations == null) {
            return serviceId;
        }
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation anno = annotationArray[n2];
            if (anno instanceof Service) {
                serviceId = ((Service)anno).value();
            }
            ++n2;
        }
        return serviceId;
    }

    public static String getRepositoryId(Annotation[] annotations) {
        String repoId = "";
        if (annotations == null) {
            return repoId;
        }
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation anno = annotationArray[n2];
            if (anno instanceof Repository) {
                repoId = ((Repository)anno).value();
            }
            ++n2;
        }
        return repoId;
    }
}

