/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.action;

import com.netsteadfast.greenstep.base.action.BaseSupportAction;
import com.netsteadfast.greenstep.base.exception.AuthorityException;
import com.netsteadfast.greenstep.base.exception.ControllerException;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.ControllerAuthority;
import com.netsteadfast.greenstep.util.JFreeChartDataMapperUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

@ControllerAuthority(check=false)
@Controller(value="core.web.controller.CommonPieChartAction")
@Scope
public class CommonPieChartAction
extends BaseSupportAction {
    private static final long serialVersionUID = 8032407128517025737L;
    private JFreeChart chart = null;
    private String oid = "";
    private String width = "";
    private String height = "";

    private void createChart() throws Exception {
        Map<String, Object> dataMap = JFreeChartDataMapperUtils.getChartData2Map(this.oid);
        if (dataMap == null) {
            return;
        }
        List names = (List)dataMap.get("names");
        List values = (List)dataMap.get("values");
        List colors = (List)dataMap.get("colors");
        this.width = String.valueOf((Integer)dataMap.get("width"));
        this.height = String.valueOf((Integer)dataMap.get("height"));
        this.fillChart((String)dataMap.get("title"), names, colors, values);
    }

    private void fillChart(String title, List<String> names, List<String> colors, List<Float> values) throws Exception {
        DefaultPieDataset data = new DefaultPieDataset();
        int ix = 0;
        while (ix < names.size()) {
            data.setValue((Comparable)((Object)names.get(ix)), values.get(ix));
            ++ix;
        }
        this.chart = ChartFactory.createPieChart3D(title, (PieDataset)data, true, true, false);
        LegendTitle legend = this.chart.getLegend();
        legend.setItemFont(new Font("", 0, 9));
        PiePlot plot = (PiePlot)this.chart.getPlot();
        plot.setCircular(true);
        plot.setBackgroundAlpha(0.9f);
        plot.setForegroundAlpha(0.5f);
        plot.setLabelFont(new Font("", 0, 9));
        this.setPlotColor(plot, names, colors);
        this.chart.setTitle(new TextTitle(title, new Font("", 0, 9)));
    }

    private void setPlotColor(PiePlot plot, List<String> names, List<String> colors) throws Exception {
        int ix = 0;
        while (ix < names.size()) {
            plot.setSectionPaint((Comparable)((Object)names.get(ix)), (Paint)Color.decode(colors.get(ix)));
            ++ix;
        }
    }

    @Override
    public String execute() throws Exception {
        String forward = "searchNoData";
        try {
            this.createChart();
            forward = "success";
        }
        catch (AuthorityException | ControllerException | ServiceException e) {
            this.setPageMessage(e.getMessage().toString());
        }
        catch (Exception e) {
            this.exceptionPage(e);
        }
        return forward;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }
}

