/*
 * Decompiled with CFR 0.152.
 */
package org.espy.arima;

import java.util.Arrays;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.QRDecomposition;

final class DoubleUtils {
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final double EQUALITY_EPSILON = 1.0E-10;

    private DoubleUtils() {
    }

    public static boolean isApproximateEqual(double a, double b) {
        return Math.abs(a - b) < 1.0E-10;
    }

    public static double getLast(double[] array) {
        return array[array.length - 1];
    }

    public static void appendWithShift(double[] array, double value) {
        if (array.length > 0) {
            System.arraycopy(array, 1, array, 0, array.length - 1);
            DoubleUtils.setLast(array, value);
        }
    }

    public static void setLast(double[] array, double value) {
        array[array.length - 1] = value;
    }

    public static double[] differentiate(double[] array) {
        double[] result = new double[array.length - 1];
        int i = 0;
        while (i < result.length) {
            result[i] = array[i + 1] - array[i];
            ++i;
        }
        return result;
    }

    public static double[] copyBegin(double[] array, int size) {
        return Arrays.copyOfRange(array, 0, size);
    }

    public static double[] copyRange(double[] array, int from, int size) {
        return Arrays.copyOfRange(array, from, from + size);
    }

    public static double[] copyEnd(double[] array, int size) {
        return Arrays.copyOfRange(array, array.length - size, array.length);
    }

    public static double[] solveSLE(double[][] A, double[] b) {
        DecompositionSolver solver = new QRDecomposition(MatrixUtils.createRealMatrix((double[][])A)).getSolver();
        if (solver.isNonSingular()) {
            return solver.solve(MatrixUtils.createRealVector((double[])b)).toArray();
        }
        return b;
    }

    public static double getMean(double[] array) {
        double sum = 0.0;
        double[] dArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            sum += value;
            ++n2;
        }
        return sum / (double)array.length;
    }

    public static double[] getMean(double[] array1, double[] array2) {
        double[] result = new double[array1.length];
        int i = 0;
        while (i < array1.length) {
            result[i] = DoubleUtils.getMean(array1[i], array2[i]);
            ++i;
        }
        return result;
    }

    public static double getMean(double value1, double value2) {
        return (value1 + value2) / 2.0;
    }
}

