/*
 * Decompiled with CFR 0.152.
 */
package org.espy.arima;

import org.espy.arima.DoubleUtils;

class DifferentiatedObservationWindow {
    private double[] lastObservationColumn;
    private double[] differentiatedObservations;

    public DifferentiatedObservationWindow(int integrationOrder, int arOrder) {
        this.lastObservationColumn = new double[integrationOrder + 1];
        this.differentiatedObservations = new double[arOrder];
    }

    public DifferentiatedObservationWindow(int integrationOrder, double[] observations) {
        this.lastObservationColumn = new double[integrationOrder + 1];
        this.lastObservationColumn[integrationOrder] = DoubleUtils.getLast(observations);
        this.differentiatedObservations = observations;
        int i = integrationOrder - 1;
        while (i >= 0) {
            this.differentiatedObservations = DoubleUtils.differentiate(observations);
            this.lastObservationColumn[i] = DoubleUtils.getLast(this.differentiatedObservations);
            --i;
        }
    }

    public double[] getDifferentiatedObservations() {
        return this.differentiatedObservations;
    }

    public double pushDifferentiatedObservation(double nextDifferentiatedObservation) {
        DoubleUtils.appendWithShift(this.differentiatedObservations, nextDifferentiatedObservation);
        this.lastObservationColumn[0] = nextDifferentiatedObservation;
        int i = 1;
        while (i < this.lastObservationColumn.length) {
            int n = i;
            this.lastObservationColumn[n] = this.lastObservationColumn[n] + this.lastObservationColumn[i - 1];
            ++i;
        }
        return DoubleUtils.getLast(this.lastObservationColumn);
    }

    public void setWindowSize(int windowSize) {
        this.differentiatedObservations = DoubleUtils.copyEnd(this.differentiatedObservations, windowSize);
    }
}

