/*
 * Decompiled with CFR 0.152.
 */
package org.espy.arima;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.espy.arima.ArimaForecaster;
import org.espy.arima.ArimaProcess;
import org.espy.arima.ArmaFormula;
import org.espy.arima.DifferentiatedObservationWindow;
import org.espy.arima.ObservationErrorWindow;

public class DefaultArimaForecaster
implements ArimaForecaster {
    private DifferentiatedObservationWindow differentiatedObservationWindow;
    private ObservationErrorWindow observationErrorWindow;
    private ArmaFormula armaFormula;

    public DefaultArimaForecaster(ArimaProcess arimaProcess, double[] observations) {
        int arOrder;
        this.differentiatedObservationWindow = new DifferentiatedObservationWindow(arimaProcess.getIntegrationOrder(), observations);
        this.observationErrorWindow = new ObservationErrorWindow(arimaProcess.getMaOrder(), arimaProcess.getExpectation());
        this.armaFormula = new ArmaFormula(ThreadLocalRandom.current());
        this.armaFormula.setArCoefficients(arimaProcess.getArCoefficients());
        this.armaFormula.setMaCoefficients(arimaProcess.getMaCoefficients());
        this.armaFormula.setExpectation(arimaProcess.getExpectation());
        this.armaFormula.setStandardDeviation(0.0);
        this.armaFormula.setConstant(arimaProcess.getConstant());
        double[] differentiatedObservations = this.differentiatedObservationWindow.getDifferentiatedObservations();
        int i = arOrder = arimaProcess.getArOrder();
        while (i < differentiatedObservations.length) {
            double[] arArguments = Arrays.copyOfRange(differentiatedObservations, i - arOrder, i);
            double[] maArguments = this.observationErrorWindow.getObservationErrors();
            double estimatedObservation = this.armaFormula.evaluate((double[])arArguments, (double[])maArguments).observation;
            double estimatedError = differentiatedObservations[i] - estimatedObservation;
            this.observationErrorWindow.pushObservationError(estimatedError);
            ++i;
        }
        this.differentiatedObservationWindow.setWindowSize(arOrder);
    }

    @Override
    public double[] next(int size) {
        double[] result = new double[size];
        int i = 0;
        while (i < size) {
            result[i] = this.next();
            ++i;
        }
        return result;
    }

    @Override
    public double next() {
        double[] arArguments = this.differentiatedObservationWindow.getDifferentiatedObservations();
        double[] maArguments = this.observationErrorWindow.getObservationErrors();
        ArmaFormula.Result result = this.armaFormula.evaluate(arArguments, maArguments);
        this.observationErrorWindow.pushObservationError(result.observationError);
        return this.differentiatedObservationWindow.pushDifferentiatedObservation(result.observation);
    }
}

