/*
 * Decompiled with CFR 0.152.
 */
package org.espy.arima;

import java.util.Random;

class ArmaFormula {
    private final Random random;
    private double[] arCoefficients;
    private double[] maCoefficients;
    private double expectation;
    private double standardDeviation;
    private double constant;

    public ArmaFormula(Random random) {
        this.random = random;
    }

    public Result evaluate(double[] arArguments, double[] maArguments) {
        Result result = new Result();
        result.observationError = this.getObservationError();
        result.observation = this.constant + result.observationError + this.getVectorConvolution(this.arCoefficients, arArguments) + this.getVectorConvolution(this.maCoefficients, maArguments);
        return result;
    }

    private double getObservationError() {
        return this.expectation + this.random.nextGaussian() * this.standardDeviation;
    }

    private double getVectorConvolution(double[] vector1, double[] vector2) {
        double result = 0.0;
        int i = 0;
        while (i < vector1.length) {
            result += vector1[i] * vector2[vector2.length - i - 1];
            ++i;
        }
        return result;
    }

    public void setArCoefficients(double[] arCoefficients) {
        this.arCoefficients = arCoefficients;
    }

    public void setMaCoefficients(double[] maCoefficients) {
        this.maCoefficients = maCoefficients;
    }

    public void setExpectation(double expectation) {
        this.expectation = expectation;
    }

    public void setStandardDeviation(double standardDeviation) {
        this.standardDeviation = standardDeviation;
    }

    public void setConstant(double constant) {
        this.constant = constant;
    }

    public static class Result {
        public double observation;
        public double observationError;
    }
}

