/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ParameterExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Parameter;
import mondrian.olap.fun.ResolvedFunCallFinder;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.Type;

public class MemberExtractingVisitor
extends MdxVisitorImpl {
    private final Set<Member> memberSet;
    private final ResolvedFunCallFinder finder;
    private final Set<Member> activeMembers = new HashSet<Member>();
    private final ResolvedFunCall call;
    private final boolean mapToAllMember;
    private static final String[] unsafeFuncNames = new String[]{"Ytd", "Mtd", "Qtd", "Wtd", "BottomCount", "TopCount", "ClosingPeriod", "Cousin", "FirstChild", "FirstSibling", "LastChild", "LastPeriods", "LastSibling", "ParallelPeriod", "PeriodsToDate", "Parent", "PrevMember", "NextMember", "Ancestor", "Ancestors"};
    private static final List<String> blacklist = Collections.unmodifiableList(Arrays.asList(unsafeFuncNames));

    public MemberExtractingVisitor(Set<Member> memberSet, ResolvedFunCall call, boolean mapToAllMember) {
        this.memberSet = memberSet;
        this.finder = new ResolvedFunCallFinder(call);
        this.call = call;
        this.mapToAllMember = mapToAllMember;
    }

    @Override
    public Object visit(ParameterExpr parameterExpr) {
        Parameter parameter = parameterExpr.getParameter();
        Type type = parameter.getType();
        if (type instanceof MemberType) {
            Object value = parameter.getValue();
            if (value instanceof Member) {
                Member member = (Member)value;
                if (!member.isMeasure() && !member.isCalculated()) {
                    this.addMember(member);
                }
            } else {
                parameter.getDefaultExp().accept(this);
            }
        }
        return null;
    }

    @Override
    public Object visit(MemberExpr memberExpr) {
        Member member = memberExpr.getMember();
        if (!member.isMeasure() && !member.isCalculated()) {
            this.addMember(member);
        } else if (member.isCalculated() && this.activeMembers.add(member)) {
            Exp exp = member.getExpression();
            this.finder.found = false;
            exp.accept(this.finder);
            if (!this.finder.found) {
                exp.accept(this);
            }
            this.activeMembers.remove(member);
        }
        return null;
    }

    @Override
    public Object visit(DimensionExpr dimensionExpr) {
        this.addToDimMemberSet(dimensionExpr.getDimension().getHierarchy());
        return null;
    }

    @Override
    public Object visit(HierarchyExpr hierarchyExpr) {
        this.addToDimMemberSet(hierarchyExpr.getHierarchy());
        return null;
    }

    @Override
    public Object visit(LevelExpr levelExpr) {
        this.addToDimMemberSet(levelExpr.getLevel().getHierarchy());
        return null;
    }

    @Override
    public Object visit(ResolvedFunCall funCall) {
        if (funCall == this.call) {
            this.turnOffVisitChildren();
        } else if (blacklist.contains(funCall.getFunName())) {
            for (Exp arg : funCall.getArgs()) {
                arg.accept(new MemberExtractingVisitor(this.memberSet, this.call, true));
            }
            this.turnOffVisitChildren();
        }
        return null;
    }

    private void addMember(Member member) {
        if (!this.mapToAllMember) {
            this.memberSet.add(member);
        } else {
            this.memberSet.add(member.getHierarchy().getAllMember());
        }
    }

    private void addToDimMemberSet(Hierarchy hierarchy) {
        if (this.mapToAllMember && !hierarchy.getDimension().isMeasures()) {
            this.memberSet.add(hierarchy.getAllMember());
        }
    }
}

