/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.Access;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Role;
import mondrian.olap.RoleImpl;
import mondrian.olap.Schema;
import mondrian.olap.Util;
import org.apache.log4j.Logger;

class UnionRoleImpl
implements Role {
    private static final Logger LOGGER = Logger.getLogger(UnionRoleImpl.class);
    private final List<Role> roleList;

    UnionRoleImpl(List<Role> roleList) {
        this.roleList = new ArrayList<Role>(roleList);
    }

    public int hashCode() {
        int hash = 11;
        for (Role r : this.roleList) {
            hash = Util.hash(hash, r);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnionRoleImpl)) {
            return false;
        }
        UnionRoleImpl r = (UnionRoleImpl)obj;
        if (r.roleList.size() != this.roleList.size()) {
            return false;
        }
        for (int cpt = 0; cpt < this.roleList.size(); ++cpt) {
            if (this.roleList.get(cpt).equals(r.roleList.get(cpt))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Access getAccess(Schema schema) {
        Role role;
        Access access = Access.NONE;
        Iterator<Role> i$ = this.roleList.iterator();
        while (i$.hasNext() && (access = UnionRoleImpl.max(access, (role = i$.next()).getAccess(schema))) != Access.ALL) {
        }
        LOGGER.debug((Object)("Access level " + (Object)((Object)access) + " granted to schema " + schema.getName() + " because of a union of roles."));
        return access;
    }

    private static <T extends Enum<T>> T max(T t1, T t2) {
        if (t1.ordinal() > t2.ordinal()) {
            return t1;
        }
        return t2;
    }

    @Override
    public Access getAccess(Cube cube) {
        Role role;
        Access access = Access.NONE;
        Iterator<Role> i$ = this.roleList.iterator();
        while (i$.hasNext() && (access = UnionRoleImpl.max(access, (role = i$.next()).getAccess(cube))) != Access.ALL) {
        }
        LOGGER.debug((Object)("Access level " + (Object)((Object)access) + " granted to cube " + cube.getName() + " because of a union of roles."));
        return access;
    }

    @Override
    public Access getAccess(Dimension dimension) {
        Role role;
        Access access = Access.NONE;
        Iterator<Role> i$ = this.roleList.iterator();
        while (i$.hasNext() && (access = UnionRoleImpl.max(access, (role = i$.next()).getAccess(dimension))) != Access.ALL) {
        }
        LOGGER.debug((Object)("Access level " + (Object)((Object)access) + " granted to dimension " + dimension.getUniqueName() + " because of a union of roles."));
        return access;
    }

    @Override
    public Access getAccess(Hierarchy hierarchy) {
        Role role;
        Access access = Access.NONE;
        Iterator<Role> i$ = this.roleList.iterator();
        while (i$.hasNext() && (access = UnionRoleImpl.max(access, (role = i$.next()).getAccess(hierarchy))) != Access.ALL) {
        }
        LOGGER.debug((Object)("Access level " + (Object)((Object)access) + " granted to hierarchy " + hierarchy.getUniqueName() + " because of a union of roles."));
        return access;
    }

    @Override
    public Role.HierarchyAccess getAccessDetails(Hierarchy hierarchy) {
        ArrayList<Role.HierarchyAccess> list = new ArrayList<Role.HierarchyAccess>();
        for (Role role : this.roleList) {
            Role.HierarchyAccess accessDetails = role.getAccessDetails(hierarchy);
            if (accessDetails == null) continue;
            list.add(accessDetails);
        }
        if (list.isEmpty()) {
            return null;
        }
        Role.HierarchyAccess hierarchyAccess = new UnionHierarchyAccessImpl(hierarchy, list);
        if (list.size() > 5) {
            hierarchyAccess = new RoleImpl.CachingHierarchyAccess(hierarchyAccess);
        }
        return hierarchyAccess;
    }

    @Override
    public Access getAccess(Level level) {
        Role role;
        Access access = Access.NONE;
        Iterator<Role> i$ = this.roleList.iterator();
        while (i$.hasNext() && (access = UnionRoleImpl.max(access, (role = i$.next()).getAccess(level))) != Access.ALL) {
        }
        LOGGER.debug((Object)("Access level " + (Object)((Object)access) + " granted to level " + level.getUniqueName() + " because of a union of roles."));
        return access;
    }

    @Override
    public Access getAccess(Member member) {
        assert (member != null);
        Role.HierarchyAccess hierarchyAccess = this.getAccessDetails(member.getHierarchy());
        if (hierarchyAccess != null) {
            return hierarchyAccess.getAccess(member);
        }
        Access access = this.getAccess(member.getDimension());
        LOGGER.debug((Object)("Access level " + (Object)((Object)access) + " granted to member " + member.getUniqueName() + " because of a union of roles."));
        return access;
    }

    @Override
    public Access getAccess(NamedSet set) {
        Role role;
        Access access = Access.NONE;
        Iterator<Role> i$ = this.roleList.iterator();
        while (i$.hasNext() && (access = UnionRoleImpl.max(access, (role = i$.next()).getAccess(set))) != Access.ALL) {
        }
        LOGGER.debug((Object)("Access level " + (Object)((Object)access) + " granted to set " + set.getUniqueName() + " because of a union of roles."));
        return access;
    }

    @Override
    public boolean canAccess(OlapElement olapElement) {
        for (Role role : this.roleList) {
            if (!role.canAccess(olapElement)) continue;
            return true;
        }
        return false;
    }

    private class UnionHierarchyAccessImpl
    implements Role.HierarchyAccess {
        private final List<Role.HierarchyAccess> list;
        private final Hierarchy hierarchy;

        UnionHierarchyAccessImpl(Hierarchy hierarchy, List<Role.HierarchyAccess> list) {
            this.hierarchy = hierarchy;
            this.list = list;
        }

        @Override
        public Access getAccess(Member member) {
            Role role;
            Access access = Access.NONE;
            int roleCount = UnionRoleImpl.this.roleList.size();
            for (int i = 0; i < roleCount && (access = (Access)UnionRoleImpl.max(access, (role = (Role)UnionRoleImpl.this.roleList.get(i)).getAccess(member))) != Access.ALL; ++i) {
            }
            LOGGER.debug((Object)("Access level " + (Object)((Object)access) + " granted to member " + member.getUniqueName() + " because of a union of roles."));
            return access;
        }

        @Override
        public int getTopLevelDepth() {
            if (!this.isTopLeveRestricted()) {
                return 0;
            }
            int access = Integer.MAX_VALUE;
            for (Role.HierarchyAccess hierarchyAccess : this.list) {
                if (hierarchyAccess.getTopLevelDepth() != 0 && (access = Math.min(access, hierarchyAccess.getTopLevelDepth())) == 0) break;
            }
            return access;
        }

        @Override
        public int getBottomLevelDepth() {
            if (!this.isBottomLeveRestricted()) {
                return this.list.get(0).getBottomLevelDepth();
            }
            int access = -1;
            for (Role.HierarchyAccess hierarchyAccess : this.list) {
                if (hierarchyAccess.getBottomLevelDepth() == this.hierarchy.getLevels().length) continue;
                access = Math.max(access, hierarchyAccess.getBottomLevelDepth());
            }
            return access;
        }

        @Override
        public Role.RollupPolicy getRollupPolicy() {
            Role.HierarchyAccess hierarchyAccess;
            Role.RollupPolicy rollupPolicy = Role.RollupPolicy.HIDDEN;
            Iterator<Role.HierarchyAccess> i$ = this.list.iterator();
            while (i$.hasNext() && (rollupPolicy = (Role.RollupPolicy)UnionRoleImpl.max(rollupPolicy, (hierarchyAccess = i$.next()).getRollupPolicy())) != Role.RollupPolicy.FULL) {
            }
            return rollupPolicy;
        }

        @Override
        public boolean hasInaccessibleDescendants(Member member) {
            Access unionAccess = this.getAccess(member);
            if (unionAccess == Access.ALL) {
                return false;
            }
            if (unionAccess == Access.NONE) {
                return true;
            }
            for (Role.HierarchyAccess hierarchyAccess : this.list) {
                if (hierarchyAccess.getAccess(member) != Access.CUSTOM || hierarchyAccess.hasInaccessibleDescendants(member)) continue;
                return false;
            }
            return true;
        }

        private boolean isTopLeveRestricted() {
            for (Role.HierarchyAccess hierarchyAccess : this.list) {
                if (hierarchyAccess.getTopLevelDepth() <= 0) continue;
                return true;
            }
            return false;
        }

        private boolean isBottomLeveRestricted() {
            for (Role.HierarchyAccess hierarchyAccess : this.list) {
                if (hierarchyAccess.getBottomLevelDepth() != this.hierarchy.getLevels().length) continue;
                return true;
            }
            return false;
        }
    }
}

