/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.eigenbase.resgen.CppGenerator;
import org.eigenbase.resgen.CppHeaderGenerator;
import org.eigenbase.resgen.FileTask;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.resgen.ResourceGen;
import org.eigenbase.resgen.ResourceGenTask;
import org.eigenbase.resgen.Util;

class XmlFileTask
extends FileTask {
    final String baseClassName;
    final String cppBaseClassName;

    XmlFileTask(ResourceGenTask.Include include, String fileName, String className, String baseClassName, boolean outputJava, String cppClassName, String cppBaseClassName, boolean outputCpp) {
        this.include = include;
        this.fileName = fileName;
        this.outputJava = outputJava;
        if (className == null) {
            className = Util.fileNameToClassName(fileName, ".xml");
        }
        this.className = className;
        if (baseClassName == null) {
            baseClassName = "org.eigenbase.resgen.ShadowResourceBundle";
        }
        this.baseClassName = baseClassName;
        this.outputCpp = outputCpp;
        if (cppClassName == null) {
            cppClassName = Util.fileNameToCppClassName(fileName, ".xml");
        }
        this.cppClassName = cppClassName;
        if (cppBaseClassName == null) {
            cppBaseClassName = "ResourceBundle";
        }
        this.cppBaseClassName = cppBaseClassName;
    }

    void process(ResourceGen generator) throws IOException {
        int i;
        URL url = Util.convertPathToURL(this.getFile());
        ResourceDef.ResourceBundle resourceList = Util.load(url);
        if (resourceList.locale == null) {
            throw new BuildException("Resource file " + url + " must have locale");
        }
        ArrayList<String> localeNames = new ArrayList<String>();
        if (this.include.root.locales == null) {
            localeNames.add(resourceList.locale);
        } else {
            StringTokenizer tokenizer = new StringTokenizer(this.include.root.locales, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                localeNames.add(token);
            }
        }
        if (!localeNames.contains(resourceList.locale)) {
            throw new BuildException("Resource file " + url + " has locale '" + resourceList.locale + "' which is not in the 'locales' list");
        }
        Locale[] locales = new Locale[localeNames.size()];
        for (i = 0; i < locales.length; ++i) {
            String localeName = (String)localeNames.get(i);
            locales[i] = Util.parseLocale(localeName);
            if (locales[i] != null) continue;
            throw new BuildException("Invalid locale " + localeName);
        }
        if (this.outputJava) {
            this.generateJava(generator, resourceList, null);
        }
        this.generateProperties(generator, resourceList, null);
        for (i = 0; i < locales.length; ++i) {
            Locale locale = locales[i];
            if (this.outputJava) {
                this.generateJava(generator, resourceList, locale);
            }
            this.generateProperties(generator, resourceList, locale);
        }
        if (this.outputCpp) {
            this.generateCpp(generator, resourceList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateProperties(ResourceGen generator, ResourceDef.ResourceBundle resourceList, Locale locale) {
        FileOutputStream out;
        File srcFile;
        String fileName = Util.getClassNameSansPackage(this.className, locale) + ".properties";
        File file = new File(this.getResourceDirectory(), fileName);
        File file2 = srcFile = locale == null ? this.getFile() : new File(this.getSrcDirectory(), fileName);
        if (file.exists()) {
            if (locale != null && file.equals(srcFile)) {
                return;
            }
            if (file.lastModified() >= srcFile.lastModified()) {
                generator.comment(file + " is up to date");
                return;
            }
            if (!file.canWrite()) {
                generator.comment(file + " is read-only");
                return;
            }
        }
        generator.comment("Generating " + file);
        try {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            out = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("Error while writing " + file, (Throwable)e);
        }
        PrintWriter pw = new PrintWriter(out);
        try {
            if (locale == null) {
                this.generateBaseProperties(resourceList, pw);
            } else {
                this.generateProperties(pw, file, srcFile, locale);
            }
        }
        finally {
            pw.close();
        }
    }

    private void generateBaseProperties(ResourceDef.ResourceBundle resourceList, PrintWriter pw) {
        String fullClassName = this.getClassName(null);
        pw.println("# This file contains the resources for");
        pw.println("# class '" + fullClassName + "'; the base locale is '" + resourceList.locale + "'.");
        pw.println("# It was generated by " + ResourceGen.class);
        pw.println("# from " + this.getFileForComments());
        if (this.include.root.commentStyle != 2) {
            pw.println("# on " + new Date().toString() + ".");
        }
        pw.println();
        for (int i = 0; i < resourceList.resources.length; ++i) {
            ResourceDef.Resource resource = resourceList.resources[i];
            String name = resource.name;
            if (resource.text == null) {
                throw new BuildException("Resource '" + name + "' has no message");
            }
            String message = resource.text.cdata;
            if (message == null) continue;
            if (this.count(resource.text.cdata, '\'') % 2 != 0) {
                System.out.println("WARNING: The message for resource '" + resource.name + "' has an odd number of single-quotes. These should" + " probably be doubled (to include an single-quote in" + " a message) or closed (to include a literal string" + " in a message).");
            }
            pw.println(name + "=" + Util.quoteForProperties(message));
        }
        pw.println("# End " + fullClassName + ".properties");
    }

    private int count(String s, char c) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    private void generateProperties(PrintWriter pw, File targetFile, File srcFile, Locale locale) {
        if (srcFile.exists() && srcFile.canRead() && !targetFile.equals(srcFile)) {
            try {
                int charsRead;
                FileReader reader = new FileReader(srcFile);
                char[] cbuf = new char[1000];
                while ((charsRead = reader.read(cbuf)) > 0) {
                    pw.write(cbuf, 0, charsRead);
                }
                return;
            }
            catch (IOException e) {
                throw new BuildException("Error while copying from '" + srcFile + "'");
            }
        }
        String fullClassName = this.getClassName(locale);
        pw.println("# This file contains the resources for");
        pw.println("# class '" + fullClassName + "' and locale '" + locale + "'.");
        pw.println("# It was generated by " + ResourceGen.class);
        pw.println("# from " + this.getFileForComments());
        if (this.include.root.commentStyle != 2) {
            pw.println("# on " + new Date().toString() + ".");
        }
        pw.println();
        pw.println("# This file is intentionally blank. Add property values");
        pw.println("# to this file to override the translations in the base");
        String basePropertiesFileName = Util.getClassNameSansPackage(this.className, locale) + ".properties";
        pw.println("# properties file, " + basePropertiesFileName);
        pw.println();
        pw.println("# End " + fullClassName + ".properties");
    }

    private String getClassName(Locale locale) {
        String s = this.className;
        if (locale != null) {
            s = s + '_' + locale.toString();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateCpp(ResourceGen generator, ResourceDef.ResourceBundle resourceList) {
        FileOutputStream cppOut;
        FileOutputStream hOut;
        String defaultExceptionClass = resourceList.cppExceptionClassName;
        String defaultExceptionLocation = resourceList.cppExceptionClassLocation;
        if (defaultExceptionClass != null && defaultExceptionLocation == null) {
            throw new BuildException("C++ exception class is defined without a header file location in " + this.getFile());
        }
        for (int i = 0; i < resourceList.resources.length; ++i) {
            ResourceDef.Resource resource = resourceList.resources[i];
            if (resource.text == null) {
                throw new BuildException("Resource '" + resource.name + "' has no message");
            }
            if (!(resource instanceof ResourceDef.Exception)) continue;
            ResourceDef.Exception exception = (ResourceDef.Exception)resource;
            if (exception.cppClassName != null && exception.cppClassLocation == null && defaultExceptionLocation == null) {
                throw new BuildException("C++ exception class specified for " + exception.name + " without specifiying a header location in " + this.getFile());
            }
            if (defaultExceptionClass != null || exception.cppClassName != null) continue;
            throw new BuildException("No exception class specified for " + exception.name + " in " + this.getFile());
        }
        String hFilename = this.cppClassName + ".h";
        String cppFileName = this.cppClassName + ".cpp";
        File hFile = new File(this.include.root.dest, hFilename);
        File cppFile = new File(this.include.root.dest, cppFileName);
        boolean allUpToDate = true;
        if (!this.checkUpToDate(generator, hFile)) {
            allUpToDate = false;
        }
        if (!this.checkUpToDate(generator, cppFile)) {
            allUpToDate = false;
        }
        if (allUpToDate && !this.include.root.force) {
            return;
        }
        generator.comment("Generating " + hFile);
        try {
            this.makeParentDirs(hFile);
            hOut = new FileOutputStream(hFile);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("Error while writing " + hFile, (Throwable)e);
        }
        String className = Util.removePackage(this.className);
        String baseClassName = Util.removePackage(this.cppBaseClassName);
        PrintWriter pw = new PrintWriter(hOut);
        try {
            CppHeaderGenerator gen = new CppHeaderGenerator(this.getFile(), hFile, className, baseClassName, defaultExceptionClass);
            this.configureCommentStyle(gen);
            gen.generateModule(generator, resourceList, pw);
        }
        finally {
            pw.close();
        }
        generator.comment("Generating " + cppFile);
        try {
            this.makeParentDirs(cppFile);
            cppOut = new FileOutputStream(cppFile);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("Error while writing " + cppFile, (Throwable)e);
        }
        pw = new PrintWriter(cppOut);
        try {
            CppGenerator gen = new CppGenerator(this.getFile(), cppFile, className, baseClassName, defaultExceptionClass, hFilename);
            this.configureCommentStyle(gen);
            gen.generateModule(generator, resourceList, pw);
        }
        finally {
            pw.close();
        }
    }
}

