/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.eigenbase.resgen.AbstractJavaGenerator;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.resgen.ResourceGen;
import org.eigenbase.resgen.ResourceInstance;
import org.eigenbase.resgen.Util;

class JavaBaseGenerator
extends AbstractJavaGenerator {
    protected final Set warnedClasses = new HashSet();

    JavaBaseGenerator(File srcFile, File file, String className, String baseClassName, ResourceDef.ResourceBundle resourceBundle) {
        super(srcFile, file, className, resourceBundle, baseClassName);
    }

    public void generateModule(ResourceGen generator, ResourceDef.ResourceBundle resourceList, PrintWriter pw) {
        this.generateHeader(pw);
        String className = this.getClassName();
        String classNameSansPackage = Util.removePackage(className);
        pw.print("public class " + classNameSansPackage);
        String baseClass = this.getBaseClassName();
        if (baseClass != null) {
            pw.print(" extends " + baseClass);
        }
        pw.println(" {");
        pw.println("    public " + classNameSansPackage + "() throws IOException {");
        pw.println("    }");
        pw.println("    private static final String baseName = " + Util.quoteForJava(this.getClassName()) + ";");
        pw.println("    /**");
        pw.println("     * Retrieves the singleton instance of {@link " + classNameSansPackage + "}. If");
        pw.println("     * the application has called {@link #setThreadLocale}, returns the");
        pw.println("     * resource for the thread's locale.");
        pw.println("     */");
        pw.println("    public static synchronized " + classNameSansPackage + " instance() {");
        pw.println("        return (" + classNameSansPackage + ") instance(baseName, getThreadOrDefaultLocale(), ResourceBundle.getBundle(baseName, getThreadOrDefaultLocale()));");
        pw.println("    }");
        pw.println("    /**");
        pw.println("     * Retrieves the instance of {@link " + classNameSansPackage + "} for the given locale.");
        pw.println("     */");
        pw.println("    public static synchronized " + classNameSansPackage + " instance(Locale locale) {");
        pw.println("        return (" + classNameSansPackage + ") instance(baseName, locale, ResourceBundle.getBundle(baseName, locale));");
        pw.println("    }");
        if (resourceList.code != null) {
            pw.println("    // begin of included code");
            pw.print(resourceList.code.cdata);
            pw.println("    // end of included code");
        }
        for (int j = 0; j < resourceList.resources.length; ++j) {
            ResourceDef.Resource resource = resourceList.resources[j];
            this.generateResource(resource, pw);
        }
        pw.println("");
        this.postModule(pw);
        pw.println("}");
    }

    protected void postModule(PrintWriter pw) {
    }

    public void generateResource(ResourceDef.Resource resource, PrintWriter pw) {
        if (resource.text == null) {
            throw new BuildException("Resource '" + resource.name + "' has no message");
        }
        String text = resource.text.cdata;
        String comment = ResourceGen.getComment(resource);
        String resourceInitcap = ResourceGen.getResourceInitcap(resource);
        String definitionClass = "org.eigenbase.resgen.ResourceDefinition";
        String parameterList = this.getParameterList(text);
        String argumentList = this.getArgumentList(text);
        String argumentArray = argumentList.equals("") ? "emptyObjectArray" : "new Object[] {" + argumentList + "}";
        pw.println();
        Util.generateCommentBlock(pw, resource.name, text, comment);
        pw.println("    public static final " + definitionClass + " " + resourceInitcap + " = new " + definitionClass + "(\"" + resourceInitcap + "\", " + Util.quoteForJava(text) + ");");
        pw.println("    public String get" + resourceInitcap + "(" + parameterList + ") {");
        pw.println("        return " + resourceInitcap + ".instantiate(" + JavaBaseGenerator.addLists("this", argumentArray) + ").toString();");
        pw.println("    }");
        if (resource instanceof ResourceDef.Exception) {
            ResourceDef.Exception exception = (ResourceDef.Exception)resource;
            String errorClassName = this.getErrorClass(exception);
            ExceptionDescription ed = new ExceptionDescription(errorClassName);
            if (ed.hasInstCon) {
                pw.println("    public " + errorClassName + " new" + resourceInitcap + "(" + parameterList + ") {");
                pw.println("        return new " + errorClassName + "(" + resourceInitcap + ".instantiate(" + JavaBaseGenerator.addLists("this", argumentArray) + "));");
                pw.println("    }");
            } else if (ed.hasInstThrowCon) {
                pw.println("    public " + errorClassName + " new" + resourceInitcap + "(" + parameterList + ") {");
                pw.println("        return new " + errorClassName + "(" + resourceInitcap + ".instantiate(" + JavaBaseGenerator.addLists("this", argumentArray) + "), null);");
                pw.println("    }");
            } else if (ed.hasStringCon) {
                pw.println("    public " + errorClassName + " new" + resourceInitcap + "(" + parameterList + ") {");
                pw.println("        return new " + errorClassName + "(get" + resourceInitcap + "(" + argumentList + "));");
                pw.println("    }");
            } else if (ed.hasStringThrowCon) {
                pw.println("    public " + errorClassName + " new" + resourceInitcap + "(" + parameterList + ") {");
                pw.println("        return new " + errorClassName + "(get" + resourceInitcap + "(" + argumentList + "), null);");
                pw.println("    }");
            }
            if (ed.hasInstThrowCon) {
                pw.println("    public " + errorClassName + " new" + resourceInitcap + "(" + JavaBaseGenerator.addLists(parameterList, "Throwable err") + ") {");
                pw.println("        return new " + errorClassName + "(" + resourceInitcap + ".instantiate(" + JavaBaseGenerator.addLists("this", argumentArray) + "), err);");
                pw.println("    }");
            } else if (ed.hasStringThrowCon) {
                pw.println("    public " + errorClassName + " new" + resourceInitcap + "(" + JavaBaseGenerator.addLists(parameterList, "Throwable err") + ") {");
                pw.println("        return new " + errorClassName + "(get" + resourceInitcap + "(" + argumentList + "), err);");
                pw.println("    }");
            }
        }
    }

    protected static String addLists(String x, String y) {
        if (x == null || x.equals("")) {
            if (y == null || y.equals("")) {
                return "";
            }
            return y;
        }
        if (y == null || y.equals("")) {
            return x;
        }
        return x + ", " + y;
    }

    protected static String addLists(String x, String y, String z) {
        return JavaBaseGenerator.addLists(x, JavaBaseGenerator.addLists(y, z));
    }

    class ExceptionDescription {
        boolean hasInstCon;
        boolean hasInstThrowCon;
        boolean hasStringCon;
        boolean hasStringThrowCon;

        ExceptionDescription(String errorClassName) {
            block8: {
                this.hasInstCon = false;
                this.hasInstThrowCon = false;
                this.hasStringCon = false;
                this.hasStringThrowCon = false;
                try {
                    Class<?> errorClass;
                    try {
                        errorClass = Class.forName(errorClassName);
                    }
                    catch (ClassNotFoundException e) {
                        errorClass = Class.forName("java.lang." + errorClassName);
                    }
                    Constructor<?>[] constructors = errorClass.getConstructors();
                    for (int i = 0; i < constructors.length; ++i) {
                        Constructor<?> constructor = constructors[i];
                        Class<?>[] types = constructor.getParameterTypes();
                        if (types.length == 1 && ResourceInstance.class.isAssignableFrom(types[0])) {
                            this.hasInstCon = true;
                        }
                        if (types.length == 1 && String.class.isAssignableFrom(types[0])) {
                            this.hasStringCon = true;
                        }
                        if (types.length == 2 && ResourceInstance.class.isAssignableFrom(types[0]) && Throwable.class.isAssignableFrom(types[1])) {
                            this.hasInstThrowCon = true;
                        }
                        if (types.length != 2 || !String.class.isAssignableFrom(types[0]) || !Throwable.class.isAssignableFrom(types[1])) continue;
                        this.hasStringThrowCon = true;
                    }
                }
                catch (ClassNotFoundException e) {
                    if (!JavaBaseGenerator.this.warnedClasses.add(errorClassName)) break block8;
                    System.out.println("Warning: Could not find exception class '" + errorClassName + "' on classpath. " + "Exception factory methods will not be generated.");
                }
            }
        }
    }
}

