/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.po.hbm.TbSysWsService;
import com.netsteadfast.greenstep.service.ISysWsServiceService;
import com.netsteadfast.greenstep.vo.SysWsServiceVO;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.ws.BindingProvider;
import org.apache.commons.lang3.StringUtils;

public class WsServiceUtils {
    private static final int TIMEOUT = 10000;
    private static ISysWsServiceService<SysWsServiceVO, TbSysWsService, String> sysWsServiceService = (ISysWsServiceService)AppContext.getBean("core.service.SysWsServiceService");

    public static Object getServiceByResource(String id) throws ServiceException, Exception {
        return WsServiceUtils.getServiceByResource(Constants.getSystem(), id);
    }

    public static Object getServiceByResource(String system, String id) throws ServiceException, Exception {
        if (StringUtils.isBlank(system) || StringUtils.isBlank(id)) {
            throw new Exception(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysWsServiceVO wsService = new SysWsServiceVO();
        wsService.setSystem(system);
        wsService.setId(id);
        DefaultResult<SysWsServiceVO> result = sysWsServiceService.findByUK(wsService);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        wsService = result.getValue();
        return WsServiceUtils.getService(wsService.getBeanId(), wsService.getWsdlAddress());
    }

    public static Object getService(String wsClientBeanId, String wsdlAddress) throws Exception {
        if (StringUtils.isBlank(wsClientBeanId)) {
            throw new IllegalArgumentException("error, bean-Id is required!");
        }
        Object serviceObj = AppContext.getBean(wsClientBeanId);
        if (!StringUtils.isBlank(wsdlAddress)) {
            BindingProvider bindingProvider = (BindingProvider)serviceObj;
            bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", wsdlAddress);
        }
        return serviceObj;
    }

    public static Object getService(String wsClientBeanId) throws Exception {
        return WsServiceUtils.getService(wsClientBeanId, null);
    }

    public static boolean testConnection(String wsdlAddress) throws Exception {
        if (StringUtils.isBlank(wsdlAddress)) {
            return true;
        }
        boolean status = false;
        try {
            URL url = new URL(wsdlAddress);
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            if (connection.getContent() != null) {
                status = true;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return status;
    }
}

