/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.model.TemplateResultObj;
import com.netsteadfast.greenstep.po.hbm.TbSysTemplate;
import com.netsteadfast.greenstep.po.hbm.TbSysTemplateParam;
import com.netsteadfast.greenstep.service.ISysTemplateParamService;
import com.netsteadfast.greenstep.service.ISysTemplateService;
import com.netsteadfast.greenstep.vo.SysTemplateParamVO;
import com.netsteadfast.greenstep.vo.SysTemplateVO;
import freemarker.cache.StringTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ognl.Ognl;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class TemplateUtils {
    private static final String IS_TITLE = "title";
    private static final String IS_MESSAGE = "message";
    private static ISysTemplateService<SysTemplateVO, TbSysTemplate, String> sysTemplateService = (ISysTemplateService)AppContext.getBean("core.service.SysTemplateService");
    private static ISysTemplateParamService<SysTemplateParamVO, TbSysTemplateParam, String> sysTemplateParamService = (ISysTemplateParamService)AppContext.getBean("core.service.SysTemplateParamService");

    private static SysTemplateVO loadSysTemplate(String templateId) throws ServiceException, Exception {
        SysTemplateVO sysTemplate = new SysTemplateVO();
        sysTemplate.setTemplateId(templateId);
        DefaultResult<SysTemplateVO> result = sysTemplateService.findByUK(sysTemplate);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        sysTemplate = result.getValue();
        return sysTemplate;
    }

    private static List<TbSysTemplateParam> loadSysTemplateParam(String templateId) throws ServiceException, Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("templateId", templateId);
        List<TbSysTemplateParam> searchList = sysTemplateParamService.findListByParams(params);
        if (searchList == null) {
            searchList = new ArrayList<TbSysTemplateParam>();
        }
        return searchList;
    }

    private static String processTemplate(String resource, Map<String, Object> params) throws Exception {
        StringTemplateLoader templateLoader = new StringTemplateLoader();
        templateLoader.putTemplate("sysTemplate", resource);
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_21);
        cfg.setTemplateLoader(templateLoader);
        Template template = cfg.getTemplate("sysTemplate", "utf-8");
        StringWriter out = new StringWriter();
        template.process(params, out);
        return ((Object)out).toString();
    }

    private static Map<String, Object> getTemplateParamMap(String type, List<TbSysTemplateParam> sysTemplateParamList, Object dataObj) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (TbSysTemplateParam sysTemplateParam : sysTemplateParamList) {
            if (IS_TITLE.equals(type)) {
                if (!"Y".equals(sysTemplateParam.getIsTitle())) continue;
                params.put(sysTemplateParam.getTemplateVar(), Ognl.getValue(sysTemplateParam.getObjectVar(), dataObj));
                continue;
            }
            if ("Y".equals(sysTemplateParam.getIsTitle())) continue;
            params.put(sysTemplateParam.getTemplateVar(), Ognl.getValue(sysTemplateParam.getObjectVar(), dataObj));
        }
        return params;
    }

    public static TemplateResultObj getResult(String templateId, Object dataObj) throws ServiceException, Exception {
        if (StringUtils.isBlank(templateId) || dataObj == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        TemplateResultObj resultObj = new TemplateResultObj();
        SysTemplateVO sysTemplate = TemplateUtils.loadSysTemplate(templateId);
        List<TbSysTemplateParam> sysTemplateParamList = TemplateUtils.loadSysTemplateParam(templateId);
        Map<String, Object> titleParams = TemplateUtils.getTemplateParamMap(IS_TITLE, sysTemplateParamList, dataObj);
        Map<String, Object> msgParams = TemplateUtils.getTemplateParamMap(IS_MESSAGE, sysTemplateParamList, dataObj);
        resultObj.setTitle(TemplateUtils.processTemplate(sysTemplate.getTitle(), titleParams));
        resultObj.setContent(TemplateUtils.processTemplate(sysTemplate.getMessage(), msgParams));
        return resultObj;
    }

    public static String escapeHtml4TemplateHtmlContent(String strContent) throws Exception {
        if (StringUtils.isBlank(strContent)) {
            return "";
        }
        return StringEscapeUtils.escapeHtml4(strContent).replaceAll("\n", "<BR/>");
    }

    public static String getResourceSrc(ClassLoader classLoader, String metaInfFile) {
        String out = "";
        try {
            out = IOUtils.toString(classLoader.getResource(metaInfFile).openStream(), "utf-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out;
    }

    public static String processTemplate(String name, ClassLoader classLoader, String templateResource, Map<String, Object> parameter) throws Exception {
        StringTemplateLoader templateLoader = new StringTemplateLoader();
        templateLoader.putTemplate("resourceTemplate", TemplateUtils.getResourceSrc(classLoader, templateResource));
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_21);
        cfg.setTemplateLoader(templateLoader);
        Template template = cfg.getTemplate("resourceTemplate", "utf-8");
        StringWriter out = new StringWriter();
        template.process(parameter, out);
        return ((Object)out).toString();
    }
}

