/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.model.SystemFtpClientData;
import com.netsteadfast.greenstep.model.SystemFtpClientResultObj;
import com.netsteadfast.greenstep.po.hbm.TbSysFtp;
import com.netsteadfast.greenstep.po.hbm.TbSysFtpTran;
import com.netsteadfast.greenstep.po.hbm.TbSysFtpTranSegm;
import com.netsteadfast.greenstep.service.ISysFtpService;
import com.netsteadfast.greenstep.service.ISysFtpTranSegmService;
import com.netsteadfast.greenstep.service.ISysFtpTranService;
import com.netsteadfast.greenstep.util.FtpClientUtils;
import com.netsteadfast.greenstep.util.SFtpClientUtils;
import com.netsteadfast.greenstep.util.ScriptExpressionUtils;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import com.netsteadfast.greenstep.vo.SysFtpTranSegmVO;
import com.netsteadfast.greenstep.vo.SysFtpTranVO;
import com.netsteadfast.greenstep.vo.SysFtpVO;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SystemFtpClientUtils {
    protected static Logger logger = Logger.getLogger(SystemFtpClientUtils.class);
    private static final int MAX_SIZE_KB = 128;
    private static ISysFtpService<SysFtpVO, TbSysFtp, String> sysFtpService = (ISysFtpService)AppContext.getBean("core.service.SysFtpService");
    private static ISysFtpTranService<SysFtpTranVO, TbSysFtpTran, String> sysFtpTranService = (ISysFtpTranService)AppContext.getBean("core.service.SysFtpTranService");
    private static ISysFtpTranSegmService<SysFtpTranSegmVO, TbSysFtpTranSegm, String> sysFtpTranSegmService = (ISysFtpTranSegmService)AppContext.getBean("core.service.SysFtpTranSegmService");

    public static SysFtpTranVO findSysFtpTran(String tranId) throws ServiceException, Exception {
        SysFtpTranVO tran = new SysFtpTranVO();
        tran.setTranId(tranId);
        DefaultResult<SysFtpTranVO> result = sysFtpTranService.findByUK(tran);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        tran = result.getValue();
        return tran;
    }

    public static SysFtpVO findSysFtp(String ftpId) throws ServiceException, Exception {
        SysFtpVO ftp = new SysFtpVO();
        ftp.setId(ftpId);
        DefaultResult<SysFtpVO> result = sysFtpService.findByUK(ftp);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        ftp = result.getValue();
        return ftp;
    }

    public static List<TbSysFtpTranSegm> findSysFtpTranSegm(String ftpId, String tranId) throws ServiceException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ftpId", ftpId);
        paramMap.put("tranId", tranId);
        return sysFtpTranSegmService.findListByParams(paramMap);
    }

    public static SystemFtpClientResultObj getFileOnly(String tranId) throws ServiceException, Exception {
        if (StringUtils.isBlank(tranId)) {
            throw new Exception(SysMessageUtil.get("MSG_UOS0001"));
        }
        logger.info("getFileOnly begin...");
        SystemFtpClientResultObj resultObj = new SystemFtpClientResultObj();
        SysFtpTranVO tran = SystemFtpClientUtils.findSysFtpTran(tranId);
        SysFtpVO ftp = SystemFtpClientUtils.findSysFtp(tran.getFtpId());
        List<TbSysFtpTranSegm> segms = SystemFtpClientUtils.findSysFtpTranSegm(tran.getFtpId(), tran.getTranId());
        resultObj.setSysFtp(ftp);
        resultObj.setSysFtpTran(tran);
        resultObj.setSysFtpTranSegms(segms);
        SystemFtpClientUtils.getFiles(resultObj);
        logger.info("getFileOnly end...");
        return resultObj;
    }

    public static SystemFtpClientResultObj getDatas(String tranId) throws ServiceException, Exception {
        logger.info("getDatas begin...");
        SystemFtpClientResultObj resultObj = SystemFtpClientUtils.getFileOnly(tranId);
        SysFtpTranVO tran = resultObj.getSysFtpTran();
        if ("GET-TXT".equals(tran.getTranType())) {
            SystemFtpClientUtils.processText(resultObj);
        } else if ("GET-XML".equals(tran.getTranType())) {
            SystemFtpClientUtils.processXml(resultObj);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("resultObj", resultObj);
        ScriptExpressionUtils.execute(tran.getExprType(), tran.getHelpExpression(), null, paramMap);
        logger.info("getDatas end...");
        return resultObj;
    }

    public static boolean putFiles(String tranId) throws ServiceException, Exception {
        if (StringUtils.isBlank(tranId)) {
            throw new Exception(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysFtpTranVO tran = SystemFtpClientUtils.findSysFtpTran(tranId);
        SysFtpVO ftp = SystemFtpClientUtils.findSysFtp(tran.getFtpId());
        if (!"PUT".equals(tran.getTranType())) {
            logger.warn("Not a PUT mode TB_SYS_FTP_TRAN.TRAN_ID: " + tranId);
            return false;
        }
        List<String> fileFullPathNames = SystemFtpClientUtils.getFileNames(tran.getExprType(), tran.getNameExpression());
        if ("FTP".equals(ftp.getType())) {
            SystemFtpClientUtils.putFilesByFtp(ftp, tran, fileFullPathNames);
        } else {
            SystemFtpClientUtils.putFileBySFtp(ftp, tran, fileFullPathNames);
        }
        return true;
    }

    public static List<String> copyFileToUpload(String system, String uploadType, boolean isFileMode, String tranId) throws ServiceException, IOException, Exception {
        SystemFtpClientResultObj resultObj = SystemFtpClientUtils.getFileOnly(tranId);
        return SystemFtpClientUtils.copyFileToUpload(system, uploadType, isFileMode, resultObj);
    }

    public static List<String> copyFileToUpload(String system, String uploadType, boolean isFileMode, SystemFtpClientResultObj resultObj) throws ServiceException, IOException, Exception {
        ArrayList<String> oids = new ArrayList<String>();
        if (resultObj == null || resultObj.getFiles() == null || resultObj.getFiles().size() < 1) {
            return oids;
        }
        for (File file : resultObj.getFiles()) {
            oids.add(UploadSupportUtils.create(system, uploadType, isFileMode, file, file.getName()));
        }
        return oids;
    }

    private static void processText(SystemFtpClientResultObj resultObj) throws Exception {
        SysFtpTranVO tran = resultObj.getSysFtpTran();
        LinkedList<SystemFtpClientData> datas = new LinkedList<SystemFtpClientData>();
        List<TbSysFtpTranSegm> segms = resultObj.getSysFtpTranSegms();
        for (File file : resultObj.getFiles()) {
            SystemFtpClientData ftpData = new SystemFtpClientData();
            LinkedList<Map<String, String>> fillDataList = new LinkedList<Map<String, String>>();
            SystemFtpClientUtils.logWarnFileSize(file);
            List<String> strLines = FileUtils.readLines(file, resultObj.getSysFtpTran().getEncoding());
            if ("Y".equals(resultObj.getSysFtpTran().getUseSegm())) {
                int i = 0;
                while (i < strLines.size()) {
                    String strData = strLines.get(i);
                    if (strData.length() < 1) {
                        logger.warn("The file: " + file.getPath() + " found zero line.");
                    } else if (i >= tran.getBeginLen()) {
                        HashMap<String, String> dataMap = new HashMap<String, String>();
                        SystemFtpClientUtils.fillStrLine2Map(resultObj.getSysFtpTran(), segms, dataMap, strData);
                        fillDataList.add(dataMap);
                    }
                    ++i;
                }
            }
            ftpData.setContent(SystemFtpClientUtils.getContent(strLines));
            ftpData.setDatas(fillDataList);
            ftpData.setFile(file);
            datas.add(ftpData);
        }
        resultObj.setDatas(datas);
    }

    private static void fillStrLine2Map(SysFtpTranVO tran, List<TbSysFtpTranSegm> segms, Map<String, String> dataMap, String strLine) throws Exception {
        if ("TEXT".equals(tran.getSegmMode())) {
            for (TbSysFtpTranSegm segm : segms) {
                if (strLine.length() < segm.getEnd()) {
                    throw new Exception("data format error.");
                }
                dataMap.put(segm.getName(), strLine.substring(segm.getBegin(), segm.getEnd()));
            }
        } else if ("BYTE".equals(tran.getSegmMode())) {
            byte[] dataBytes = strLine.getBytes(tran.getEncoding());
            for (TbSysFtpTranSegm segm : segms) {
                if (dataBytes.length < segm.getEnd()) {
                    throw new Exception("data format error.");
                }
                String dataStr = new String(ArrayUtils.subarray(dataBytes, segm.getBegin(), segm.getEnd()), tran.getEncoding());
                dataMap.put(segm.getName(), dataStr);
            }
        } else {
            String[] tmpStr = strLine.split(tran.getSegmSymbol());
            for (TbSysFtpTranSegm segm : segms) {
                if (segm.getBegin() != segm.getEnd()) {
                    throw new Exception("segment config begin/end error.");
                }
                if (segm.getBegin() != segm.getEnd()) {
                    throw new Exception("segment config begin/end error.");
                }
                dataMap.put(segm.getName(), tmpStr[segm.getBegin()]);
            }
        }
    }

    private static void processXml(SystemFtpClientResultObj resultObj) throws Exception {
        SysFtpTranVO tran = resultObj.getSysFtpTran();
        LinkedList<SystemFtpClientData> datas = new LinkedList<SystemFtpClientData>();
        JAXBContext jaxbContext = null;
        Unmarshaller jaxbUnmarshaller = null;
        if (!StringUtils.isBlank(tran.getXmlClassName())) {
            Class<?> xmlBeanClazz = Class.forName(tran.getXmlClassName());
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{xmlBeanClazz});
            jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        }
        for (File file : resultObj.getFiles()) {
            SystemFtpClientData ftpData = new SystemFtpClientData();
            SystemFtpClientUtils.logWarnFileSize(file);
            String content = FileUtils.readFileToString(file, "utf-8");
            ftpData.setContent(content);
            ftpData.setDatas(null);
            ftpData.setFile(file);
            if (jaxbUnmarshaller != null) {
                Object obj = jaxbUnmarshaller.unmarshal((InputStream)new ByteArrayInputStream(content.getBytes("utf-8")));
                ftpData.setXmlBean(obj);
            }
            datas.add(ftpData);
        }
        resultObj.setDatas(datas);
    }

    private static String getContent(List<String> strLines) {
        StringBuilder sb = new StringBuilder();
        for (String str : strLines) {
            sb.append(str);
        }
        return sb.toString();
    }

    private static void getFiles(SystemFtpClientResultObj resultObj) throws Exception {
        List<String> names = SystemFtpClientUtils.getFileNames(resultObj.getSysFtpTran().getExprType(), resultObj.getSysFtpTran().getNameExpression());
        if (names == null || names.size() < 1) {
            throw new Exception("No file name, Please settings name expression ( TB_SYS_FTP_TRAN.NAME_EXPRESSION ) ");
        }
        resultObj.setNames(names);
        if ("FTP".equals(resultObj.getSysFtp().getType())) {
            SystemFtpClientUtils.getFilesByFtp(resultObj);
        } else {
            SystemFtpClientUtils.getFilesBySFtp(resultObj);
        }
    }

    private static void getFilesByFtp(SystemFtpClientResultObj resultObj) throws Exception {
        SysFtpVO ftp = resultObj.getSysFtp();
        SysFtpTranVO tran = resultObj.getSysFtpTran();
        FtpClientUtils ftpClient = new FtpClientUtils();
        File storeDir = SystemFtpClientUtils.getStoreDir();
        try {
            try {
                ftpClient.login(ftp.getAddress(), ftp.getUser(), ftp.getPass());
                for (String name : resultObj.getNames()) {
                    ftpClient.get(tran.getCwd(), storeDir, name);
                }
                SystemFtpClientUtils.fillStoreDirFiles(storeDir, resultObj);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            storeDir = null;
            ftpClient.close();
            ftpClient = null;
        }
    }

    private static void getFilesBySFtp(SystemFtpClientResultObj resultObj) throws Exception {
        SysFtpVO ftp = resultObj.getSysFtp();
        File storeDir = SystemFtpClientUtils.getStoreDir();
        ArrayList<String> localFile = new ArrayList<String>();
        for (String name : resultObj.getNames()) {
            localFile.add(String.valueOf(storeDir.getPath()) + "/" + name);
        }
        try {
            try {
                SFtpClientUtils.get(ftp.getUser(), ftp.getPass(), ftp.getAddress(), ftp.getPort(), resultObj.getNames(), localFile);
                SystemFtpClientUtils.fillStoreDirFiles(storeDir, resultObj);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            storeDir = null;
        }
    }

    private static void putFilesByFtp(SysFtpVO ftp, SysFtpTranVO tran, List<String> fileFullPathNames) throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        for (String name : fileFullPathNames) {
            File file = new File(name);
            files.add(file);
        }
        FtpClientUtils ftpClient = new FtpClientUtils();
        try {
            try {
                ftpClient.login(ftp.getAddress(), ftp.getUser(), ftp.getPass());
                for (File file : files) {
                    ftpClient.put(tran.getCwd(), file.getName(), file);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            ftpClient.close();
            ftpClient = null;
        }
    }

    private static void putFileBySFtp(SysFtpVO ftp, SysFtpTranVO tran, List<String> fileFullPathNames) throws Exception {
        ArrayList<String> remoteFile = new ArrayList<String>();
        for (String name : fileFullPathNames) {
            File file = new File(name);
            remoteFile.add(file.getName());
        }
        try {
            SFtpClientUtils.put(ftp.getUser(), ftp.getPass(), ftp.getAddress(), ftp.getPort(), fileFullPathNames, remoteFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static List<String> getFileNames(String expressionType, String nameExpression) throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        Map<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("fileName", names);
        dataMap = ScriptExpressionUtils.execute(expressionType, nameExpression, dataMap, dataMap);
        return names;
    }

    private static File getStoreDir() throws IOException {
        File storeDir = new File(String.valueOf(Constants.getWorkTmpDir()) + "/" + SystemFtpClientUtils.class.getSimpleName() + "/" + System.currentTimeMillis());
        FileUtils.forceMkdir(storeDir);
        return storeDir;
    }

    private static void fillStoreDirFiles(File storeDir, SystemFtpClientResultObj resultObj) throws Exception {
        File[] localFiles = storeDir.listFiles();
        ArrayList<File> files = new ArrayList<File>();
        File[] fileArray = localFiles;
        int n = localFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            files.add(file);
            ++n2;
        }
        resultObj.setFiles(files);
    }

    private static void logWarnFileSize(File file) throws Exception {
        long bytes = file.length();
        if (bytes > 0L && bytes / 1024L > 128L) {
            logger.warn("The file: " + file.getPath() + " is bigger then " + 128 + " kb size. please change SYS_FTP.TYPE type to " + "GET");
        }
    }
}

