/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.util.OlapUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.StringWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.olap4j.OlapConnection;
import org.olap4j.OlapDataSource;
import org.pivot4j.PivotModel;
import org.pivot4j.datasource.SingleConnectionOlapDataSource;
import org.pivot4j.impl.PivotModelImpl;
import org.pivot4j.ui.html.HtmlRenderCallback;
import org.pivot4j.ui.poi.ExcelExporter;
import org.pivot4j.ui.poi.Format;
import org.pivot4j.ui.table.TableRenderer;

public class Pivot4JUtils {
    public static final String PIVOT4J_HTML_CSS = "META-INF/pivot4j-html-table-css.css";
    private static final String _body_default = "<HTML><HEAD><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><style>${style}</style></HEAD><BODY>${body}</BODY></HTML>";
    private static String _htmlCss = "";

    public static String getHtmlCss() throws Exception {
        if (!StringUtils.isBlank(_htmlCss)) {
            return _htmlCss;
        }
        InputStream is = Pivot4JUtils.class.getClassLoader().getResource(PIVOT4J_HTML_CSS).openStream();
        _htmlCss = IOUtils.toString(is, "utf-8");
        is.close();
        is = null;
        return _htmlCss;
    }

    private static PivotModel getPivotModel(OlapDataSource dataSource, String mdx) throws Exception {
        PivotModelImpl model = new PivotModelImpl(dataSource);
        model.setMdx(mdx);
        model.initialize();
        return model;
    }

    private static TableRenderer getTableRenderer(boolean showDimensionTitle, boolean showParentMembers) {
        TableRenderer renderer = new TableRenderer();
        renderer.setShowDimensionTitle(showDimensionTitle);
        renderer.setShowParentMembers(showParentMembers);
        return renderer;
    }

    public static String rendererHtml(String mondrianUrl, String mdx, boolean showDimensionTitle, boolean showParentMembers) throws Exception {
        if (StringUtils.isBlank(mondrianUrl) || StringUtils.isBlank(mdx)) {
            throw new IllegalArgumentException("mondrian url and MDX cannot blank.");
        }
        String body = "";
        OlapConnection connection = OlapUtils.getConnection(mondrianUrl);
        SingleConnectionOlapDataSource dataSource = new SingleConnectionOlapDataSource(connection);
        try {
            PivotModel model = Pivot4JUtils.getPivotModel(dataSource, mdx);
            TableRenderer renderer = Pivot4JUtils.getTableRenderer(showDimensionTitle, showParentMembers);
            StringWriter writer = new StringWriter();
            renderer.render(model, new HtmlRenderCallback(writer));
            body = writer.toString();
            writer.flush();
            writer.close();
        }
        finally {
            OlapUtils.nullConnection(connection);
            connection = null;
            dataSource = null;
        }
        return body;
    }

    public static String wrapRendererHtml(String content) throws Exception {
        String str = StringUtils.replaceOnce(_body_default, "${style}", Pivot4JUtils.getHtmlCss());
        str = StringUtils.replaceOnce(str, "${body}", content);
        return str;
    }

    public static byte[] exportExcelToBytes(String mondrianUrl, String mdx, boolean showDimensionTitle, boolean showParentMembers) throws Exception {
        byte[] datas = null;
        File file = null;
        try {
            file = Pivot4JUtils.exportExcelFile(mondrianUrl, mdx, showDimensionTitle, showParentMembers);
            datas = FileUtils.readFileToByteArray(file);
        }
        finally {
            file = null;
        }
        return datas;
    }

    public static File exportExcelFile(String mondrianUrl, String mdx, boolean showDimensionTitle, boolean showParentMembers) throws Exception {
        if (StringUtils.isBlank(mondrianUrl) || StringUtils.isBlank(mdx)) {
            throw new IllegalArgumentException("mondrian url and MDX cannot blank.");
        }
        File file = new File(String.valueOf(Constants.getWorkTmpDir()) + "/" + SimpleUtils.getUUIDStr() + ".xlsx");
        FileOutputStream os = new FileOutputStream(file);
        OlapConnection connection = OlapUtils.getConnection(mondrianUrl);
        SingleConnectionOlapDataSource dataSource = new SingleConnectionOlapDataSource(connection);
        try {
            try {
                PivotModel model = Pivot4JUtils.getPivotModel(dataSource, mdx);
                TableRenderer renderer = Pivot4JUtils.getTableRenderer(showDimensionTitle, showParentMembers);
                ExcelExporter exporter = new ExcelExporter(os);
                exporter.setFormat(Format.XSSF);
                renderer.render(model, exporter);
            }
            catch (Exception e) {
                file = null;
                throw e;
            }
        }
        finally {
            if (os != null) {
                IOUtils.closeQuietly(os);
                os = null;
            }
            OlapUtils.nullConnection(connection);
            connection = null;
            dataSource = null;
        }
        return file;
    }
}

