/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;

public class PdfConvertUtils {
    public static List<String> toImageUpload(File pdfFile, int resolution, String system, String uploadType, boolean isFile) throws ServiceException, Exception {
        LinkedList<String> oids = new LinkedList<String>();
        List<File> imageFiles = PdfConvertUtils.toImageFiles(pdfFile, resolution);
        for (File file : imageFiles) {
            oids.add(UploadSupportUtils.create(system, uploadType, isFile, file, file.getName()));
        }
        return oids;
    }

    public static List<File> toImageFiles(File pdfFile, int resolution) throws Exception {
        PDDocument document = PDDocument.load(pdfFile);
        PDFRenderer pdfRenderer = new PDFRenderer(document);
        File tmpDir = new File(String.valueOf(Constants.getWorkTmpDir()) + "/" + PdfConvertUtils.class.getSimpleName() + "/" + System.currentTimeMillis() + "/");
        FileUtils.forceMkdir(tmpDir);
        LinkedList<File> files = new LinkedList<File>();
        int len = String.valueOf(document.getDocumentCatalog().getPages().getCount() + 1).length();
        int i = 0;
        while (i < document.getDocumentCatalog().getPages().getCount()) {
            String name = StringUtils.leftPad(String.valueOf(i + 1), len, "0");
            BufferedImage bufImage = pdfRenderer.renderImageWithDPI(i, resolution, ImageType.RGB);
            File imageFile = new File(String.valueOf(tmpDir.getPath()) + "/" + name + ".png");
            FileOutputStream fos = new FileOutputStream(imageFile);
            ImageIOUtil.writeImage(bufImage, "png", fos, resolution);
            fos.flush();
            fos.close();
            files.add(imageFile);
            ++i;
        }
        document.close();
        tmpDir = null;
        return files;
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length != 2) {
            System.out.println("PdfConvertUtils [FILE] [RESOLUTION]");
            System.out.println("Example: PdfConvertUtils /test.pdf 120");
            System.exit(1);
        }
        System.out.println("source document file: " + args[0]);
        int res = NumberUtils.toInt(args[1], 300);
        List<File> imageFiles = PdfConvertUtils.toImageFiles(new File(args[0]), res);
        for (File file : imageFiles) {
            System.out.println(file.getPath());
        }
    }
}

