/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class JFreeChartDataMapperUtils {
    protected static Logger logger = Logger.getLogger(JFreeChartDataMapperUtils.class);

    private static String createUploadData(Map<String, Object> dataMap) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonData = objectMapper.writeValueAsString(dataMap);
        return UploadSupportUtils.create(Constants.getSystem(), "tmp", false, jsonData.getBytes(), String.valueOf(SimpleUtils.getUUIDStr()) + ".json");
    }

    public static Map<String, Object> fillBarDataMap(String categoryLabel, String valueLabel, String title, List<String> names, List<Float> values, List<String> colors, int width, int height, boolean horizontal) throws Exception {
        if (names == null || values == null || colors == null || names.size() != values.size() || names.size() != colors.size() || names.size() < 1) {
            throw new Exception(SysMessageUtil.get("MSG_UOS0002"));
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("categoryLabel", categoryLabel);
        dataMap.put("valueLabel", valueLabel);
        dataMap.put("title", title);
        dataMap.put("names", names);
        dataMap.put("values", values);
        dataMap.put("colors", colors);
        dataMap.put("width", width);
        dataMap.put("height", height);
        dataMap.put("horizontal", horizontal ? "Y" : "N");
        return dataMap;
    }

    public static String createBarData(String categoryLabel, String valueLabel, String title, List<String> names, List<Float> values, List<String> colors, int width, int height, boolean horizontal) throws Exception {
        Map<String, Object> barDataMap = JFreeChartDataMapperUtils.fillBarDataMap(categoryLabel, valueLabel, title, names, values, colors, width, height, horizontal);
        return JFreeChartDataMapperUtils.createUploadData(barDataMap);
    }

    public static String createPieData(String title, List<String> names, List<Float> values, List<String> colors, int width, int height) throws Exception {
        Map<String, Object> barDataMap = JFreeChartDataMapperUtils.fillPieDataMap(title, names, values, colors, width, height);
        return JFreeChartDataMapperUtils.createUploadData(barDataMap);
    }

    public static Map<String, Object> fillPieDataMap(String title, List<String> names, List<Float> values, List<String> colors, int width, int height) throws Exception {
        if (names == null || values == null || colors == null || names.size() != values.size() || names.size() != colors.size() || names.size() < 1) {
            throw new Exception(SysMessageUtil.get("MSG_UOS0002"));
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("title", title);
        dataMap.put("names", names);
        dataMap.put("values", values);
        dataMap.put("colors", colors);
        dataMap.put("width", width);
        dataMap.put("height", height);
        return dataMap;
    }

    public static String createMeterData(String title, float value, int lowerBound, int upperBound, int width, int height) throws Exception {
        Map<String, Object> meterDataMap = JFreeChartDataMapperUtils.fillMeterDataMap(title, value, lowerBound, upperBound, width, height);
        return JFreeChartDataMapperUtils.createUploadData(meterDataMap);
    }

    public static Map<String, Object> fillMeterDataMap(String title, float value, int lowerBound, int upperBound, int width, int height) throws Exception {
        if (title == null) {
            throw new Exception(SysMessageUtil.get("MSG_UOS0002"));
        }
        if (lowerBound >= upperBound) {
            logger.warn("fillMeterDataMap variable lowerBound(args): " + lowerBound);
            logger.warn("fillMeterDataMap variable upperBound(args): " + upperBound);
            lowerBound = 0;
            upperBound = 100;
            logger.warn("fillMeterDataMap variable lowerBound(replace-to): " + lowerBound);
            logger.warn("fillMeterDataMap variable upperBound(replace-to): " + upperBound);
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("title", title);
        dataMap.put("value", String.valueOf(value));
        dataMap.put("lowerBound", lowerBound);
        dataMap.put("upperBound", upperBound);
        dataMap.put("width", width);
        dataMap.put("height", height);
        return dataMap;
    }

    public static Map<String, Object> getChartData2Map(String uploadOid) throws Exception {
        if (StringUtils.isBlank(uploadOid)) {
            throw new Exception(SysMessageUtil.get("MSG_UOS0001"));
        }
        String jsonData = new String(UploadSupportUtils.getDataBytes(uploadOid));
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readValue(jsonData, HashMap.class);
    }
}

