/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.sys;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.ContextInitializedAndDestroyedBean;
import com.netsteadfast.greenstep.po.hbm.TbSysCtxBean;
import com.netsteadfast.greenstep.service.ISysCtxBeanService;
import com.netsteadfast.greenstep.vo.SysCtxBeanVO;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class WebSystemCtxBeanSupportListener
implements ServletContextListener {
    protected Logger logger = Logger.getLogger(WebSystemCtxBeanSupportListener.class);
    private ISysCtxBeanService<SysCtxBeanVO, TbSysCtxBean, String> sysCtxBeanService;

    private List<TbSysCtxBean> findSysCtxBeanList(String type) throws ServiceException, Exception {
        this.sysCtxBeanService = (ISysCtxBeanService)AppContext.getBean("core.service.SysCtxBeanService");
        List<TbSysCtxBean> ctxBeans = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", type);
        params.put("system", Constants.getSystem());
        ctxBeans = this.sysCtxBeanService.findListByParams(params);
        if (ctxBeans == null) {
            ctxBeans = new ArrayList<TbSysCtxBean>();
        }
        return ctxBeans;
    }

    private void processBean(ServletContextEvent event, String type) {
        try {
            List<TbSysCtxBean> ctxBeans = this.findSysCtxBeanList(type);
            int i = 0;
            while (ctxBeans != null && i < ctxBeans.size()) {
                block12: {
                    TbSysCtxBean bean = ctxBeans.get(i);
                    try {
                        Method[] methods;
                        Object executerObj = Class.forName(bean.getClassName()).newInstance();
                        if (!(executerObj instanceof ContextInitializedAndDestroyedBean)) {
                            this.logger.warn("class not instanceof ContextInitializedAndDestroyedBean : " + bean.getClassName());
                            break block12;
                        }
                        Method[] methodArray = methods = executerObj.getClass().getMethods();
                        int n = methods.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Method method = methodArray[n2];
                            if (method.getName().equals("execute")) {
                                try {
                                    method.invoke(executerObj, event);
                                }
                                catch (ServiceException se) {
                                    se.printStackTrace();
                                    this.logger.warn(se.getMessage().toString());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    this.logger.error(e.getMessage().toString());
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        cnfe.printStackTrace();
                        this.logger.error(cnfe.getMessage().toString());
                    }
                }
                ++i;
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.processBean(event, "DESTROY");
    }

    public void contextInitialized(ServletContextEvent event) {
        this.processBean(event, "INITIALIZE");
    }
}

