/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.sys;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.model.WebMessagePublishBaseObj;
import com.netsteadfast.greenstep.po.hbm.TbSysMsgNoticeConfig;
import com.netsteadfast.greenstep.publish.BaseMessagePublishService;
import com.netsteadfast.greenstep.service.ISysMsgNoticeConfigService;
import com.netsteadfast.greenstep.vo.SysMsgNoticeConfigVO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class WebMessagePublishListener
implements ServletContextListener {
    private static final long SLEEP_TIME = 5000L;
    private ISysMsgNoticeConfigService<SysMsgNoticeConfigVO, TbSysMsgNoticeConfig, String> sysMsgNoticeConfigService;
    private List<AsyncContext> asyncContexts = new ArrayList<AsyncContext>();
    private Thread webMessagePublishThread = null;
    private WebMessagePublishRunnable webMessagePublishRunnable = null;

    public void contextInitialized(ServletContextEvent event) {
        if (this.sysMsgNoticeConfigService == null) {
            this.sysMsgNoticeConfigService = (ISysMsgNoticeConfigService)AppContext.getBean("core.service.SysMsgNoticeConfigService");
        }
        event.getServletContext().setAttribute("asyncContexts", this.asyncContexts);
        this.webMessagePublishRunnable = new WebMessagePublishRunnable(this.asyncContexts);
        this.webMessagePublishThread = new Thread(this.webMessagePublishRunnable);
        this.webMessagePublishThread.start();
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.webMessagePublishRunnable.stopRunning();
        this.webMessagePublishThread.interrupt();
        try {
            this.webMessagePublishThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.webMessagePublishThread = null;
        this.webMessagePublishRunnable = null;
    }

    private class WebMessagePublishRunnable
    implements Runnable {
        private volatile boolean running = true;
        private Map<String, BaseMessagePublishService> publicServices = new HashMap<String, BaseMessagePublishService>();
        private Map<String, SysMsgNoticeConfigVO> msgNoticeConfigMap = new HashMap<String, SysMsgNoticeConfigVO>();
        private List<AsyncContext> asyncContexts = null;

        public WebMessagePublishRunnable(List<AsyncContext> asyncContexts) {
            this.asyncContexts = asyncContexts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                List<AsyncContext> list = this.asyncContexts;
                synchronized (list) {
                    for (AsyncContext context : this.asyncContexts) {
                        try {
                            WebMessagePublishBaseObj publishObj = null;
                            context.getResponse().setContentType("application/json; charset=utf-8");
                            String id = StringUtils.defaultString(context.getRequest().getParameter("id")).trim();
                            String key = String.valueOf(id) + ":" + Constants.getSystem();
                            if (!StringUtils.isBlank(id)) {
                                SysMsgNoticeConfigVO config = this.msgNoticeConfigMap.get(key);
                                if (config == null) {
                                    config = new SysMsgNoticeConfigVO();
                                    config.setMsgId(id);
                                    try {
                                        DefaultResult<SysMsgNoticeConfigVO> result = WebMessagePublishListener.this.sysMsgNoticeConfigService.findByUK(config);
                                        if (result.getValue() != null) {
                                            config = result.getValue();
                                            this.msgNoticeConfigMap.put(key, config);
                                        }
                                    }
                                    catch (ServiceException e) {
                                        e.printStackTrace();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (config != null && !StringUtils.isBlank(config.getOid())) {
                                    BaseMessagePublishService messagePublishService = this.publicServices.get(key);
                                    if (messagePublishService == null) {
                                        try {
                                            messagePublishService = (BaseMessagePublishService)Class.forName(config.getClassName()).newInstance();
                                            this.publicServices.put(key, messagePublishService);
                                        }
                                        catch (InstantiationException e) {
                                            e.printStackTrace();
                                        }
                                        catch (IllegalAccessException e) {
                                            e.printStackTrace();
                                        }
                                        catch (ClassNotFoundException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    if (messagePublishService != null) {
                                        try {
                                            publishObj = messagePublishService.execute(config, context.getRequest());
                                        }
                                        catch (ServiceException e) {
                                            e.printStackTrace();
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }
                            }
                            if (publishObj == null) {
                                publishObj = new WebMessagePublishBaseObj();
                            }
                            context.getResponse().getWriter().println(JSONObject.fromObject(publishObj).toString());
                            context.complete();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    this.asyncContexts.clear();
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }

        public void stopRunning() {
            this.running = false;
        }
    }
}

