/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.sys;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.util.ApplicationSiteUtils;
import com.netsteadfast.greenstep.util.EncryptorUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class GreenStepHessianUtils {
    public static final String HEADER_CHECK_VALUE_PARAM_NAME = "greenstep_hessian_auth_check_value";
    public static final String CHECK_VALUE_PARAM_NAME = "checkValue";
    public static final String USER_ID_PARAM_NAME = "accountId";
    private static String configHessianUrlPattern = "/hessian/";
    private static String configHessianExtensionName = ".hessian";
    private static Map<String, Object> configMap = null;
    private static String checkValue = "W$oTj09!Rq@N30l$";
    private static List<String> proxyServiceId = new ArrayList<String>();
    private static List<String> proxyBlockedAccountId = new ArrayList<String>();

    static {
        configMap = (Map)AppContext.getBean("hessian.config");
        checkValue = SimpleUtils.getStr(String.valueOf(configMap.get(CHECK_VALUE_PARAM_NAME)), checkValue);
        if (checkValue.trim().length() < 1) {
            checkValue = "W$oTj09!Rq@N30l$";
        }
        String proxyServiceIdStr = StringUtils.defaultString(String.valueOf(configMap.get("proxyServiceId"))).replaceAll("\t", "").replaceAll("\n", "").replaceAll(" ", "").trim();
        String[] serviceIdTmp = proxyServiceIdStr.split(",");
        int i = 0;
        while (serviceIdTmp != null && i < serviceIdTmp.length) {
            String serviceId = serviceIdTmp[i].replaceAll(" ", "").trim();
            if (!StringUtils.isBlank(serviceId)) {
                proxyServiceId.add(serviceId);
            }
            ++i;
        }
        String proxyBlockedAccountIdStr = StringUtils.defaultString(String.valueOf(configMap.get("proxyBlockedAccountId"))).replaceAll("\t", "").replaceAll("\n", "").replaceAll(" ", "").trim();
        String[] blockedAccountIdTmp = proxyBlockedAccountIdStr.split(",");
        int i2 = 0;
        while (blockedAccountIdTmp != null && i2 < blockedAccountIdTmp.length) {
            String accountId = blockedAccountIdTmp[i2].replaceAll(" ", "").trim();
            if (!StringUtils.isBlank(accountId)) {
                proxyBlockedAccountId.add(accountId);
            }
            ++i2;
        }
        if (!StringUtils.isBlank((String)configMap.get("configHessianUrlPattern"))) {
            configHessianUrlPattern = String.valueOf(configMap.get("configHessianUrlPattern")).trim();
        }
        if (!StringUtils.isBlank((String)configMap.get("configHessianExtensionName"))) {
            configHessianExtensionName = String.valueOf(configMap.get("configHessianExtensionName")).trim();
        }
    }

    public static Map<String, Object> getConfigMap() {
        return configMap;
    }

    public static String getConfigHessianUrlPattern() {
        return configHessianUrlPattern;
    }

    public static String getConfigHessianExtensionName() {
        return configHessianExtensionName;
    }

    public static boolean getConfigHessianHeaderCheckValueModeEnable() {
        return "Y".equals(configMap.get("configHessianHeaderCheckValueModeEnable"));
    }

    public static boolean isEnableCallRemote() {
        return "Y".equals(configMap.get("enable"));
    }

    public static String getServerUrl() {
        return String.valueOf(configMap.get("serverUrl")).trim();
    }

    public static String getUserId(Map<String, String> dataMap) {
        return dataMap.get(USER_ID_PARAM_NAME);
    }

    public static String getCheckValue(Map<String, String> dataMap) {
        return dataMap.get(CHECK_VALUE_PARAM_NAME);
    }

    public static String getHttpRequestHeaderCheckValue(HttpServletRequest request) {
        return request.getHeader(HEADER_CHECK_VALUE_PARAM_NAME);
    }

    public static boolean isCheckValue(Map<String, String> dataMap) throws Exception {
        return GreenStepHessianUtils.isCheckValue(dataMap.get(CHECK_VALUE_PARAM_NAME));
    }

    public static boolean isCheckValue(String decCheckValue) throws Exception {
        return checkValue.equals(decCheckValue);
    }

    public static boolean isProxyServiceId(String serviceId) {
        return proxyServiceId.contains(serviceId);
    }

    public static boolean isProxyBlockedAccountId(String accountId) {
        return proxyBlockedAccountId.contains(accountId);
    }

    public static String getEncAuthValue(String accountId) throws Exception {
        if (StringUtils.isBlank(accountId)) {
            throw new Exception("accountId is required!");
        }
        String value = String.valueOf(checkValue) + ";" + SimpleUtils.createRandomString(8) + ";" + System.currentTimeMillis() + ";" + accountId;
        return SimpleUtils.toHex(EncryptorUtils.encrypt(Constants.getEncryptorKey1(), Constants.getEncryptorKey2(), value));
    }

    public static Map<String, String> getDecAuthValue(String encValue) throws Exception {
        String value = EncryptorUtils.decrypt(Constants.getEncryptorKey1(), Constants.getEncryptorKey2(), SimpleUtils.deHex(encValue));
        String[] val = StringUtils.defaultString(value).trim().split(";");
        if (val.length != 4) {
            return null;
        }
        if (val[0].trim().length() < 1 || val[1].trim().length() != 8 || !NumberUtils.isCreatable(val[2]) || !SimpleUtils.checkBeTrueOf_azAZ09(val[3])) {
            return null;
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(CHECK_VALUE_PARAM_NAME, val[0].trim());
        data.put(USER_ID_PARAM_NAME, val[3].trim());
        return data;
    }

    public static String getServiceUrl(String serviceBeanId) throws Exception {
        String contextPath = String.valueOf(ApplicationSiteUtils.getContextPath(Constants.getSystem())) + GreenStepHessianUtils.getConfigHessianUrlPattern();
        String url = String.valueOf(GreenStepHessianUtils.getServerUrl()) + contextPath + serviceBeanId + GreenStepHessianUtils.getConfigHessianExtensionName();
        return url;
    }
}

