/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.sys;

import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.po.hbm.TbAccount;
import com.netsteadfast.greenstep.po.hbm.TbRolePermission;
import com.netsteadfast.greenstep.po.hbm.TbUserRole;
import com.netsteadfast.greenstep.service.IAccountService;
import com.netsteadfast.greenstep.service.IRolePermissionService;
import com.netsteadfast.greenstep.service.IUserRoleService;
import com.netsteadfast.greenstep.sys.GreenStepBaseUsernamePasswordToken;
import com.netsteadfast.greenstep.vo.AccountVO;
import com.netsteadfast.greenstep.vo.RolePermissionVO;
import com.netsteadfast.greenstep.vo.UserRoleVO;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class GreenStepBaseAuthorizingRealm
extends AuthorizingRealm {
    private IAccountService<AccountVO, TbAccount, String> accountService;
    private IUserRoleService<UserRoleVO, TbUserRole, String> userRoleService;
    private IRolePermissionService<RolePermissionVO, TbRolePermission, String> rolePermissionService;

    public IAccountService<AccountVO, TbAccount, String> getAccountService() {
        return this.accountService;
    }

    @Autowired
    @Resource(name="core.service.AccountService")
    @Required
    public void setAccountService(IAccountService<AccountVO, TbAccount, String> accountService) {
        this.accountService = accountService;
    }

    public IUserRoleService<UserRoleVO, TbUserRole, String> getUserRoleService() {
        return this.userRoleService;
    }

    @Autowired
    @Resource(name="core.service.UserRoleService")
    @Required
    public void setUserRoleService(IUserRoleService<UserRoleVO, TbUserRole, String> userRoleService) {
        this.userRoleService = userRoleService;
    }

    public IRolePermissionService<RolePermissionVO, TbRolePermission, String> getRolePermissionService() {
        return this.rolePermissionService;
    }

    @Autowired
    @Resource(name="core.service.RolePermissionService")
    @Required
    public void setRolePermissionService(IRolePermissionService<RolePermissionVO, TbRolePermission, String> rolePermissionService) {
        this.rolePermissionService = rolePermissionService;
    }

    private SimpleAuthorizationInfo getSimpleAuthorizationInfo(String username) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("account", username);
        List roleList = this.userRoleService.findListByParams(params);
        if (roleList == null) {
            return null;
        }
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        for (TbUserRole userRole : roleList) {
            info.addRole(userRole.getRole());
            params.clear();
            params.put("role", userRole.getRole());
            List rolePermissionList = this.rolePermissionService.findListByParams(params);
            if (rolePermissionList == null) continue;
            for (TbRolePermission rolePermission : rolePermissionList) {
                info.addStringPermission(rolePermission.getPermission());
            }
        }
        return info;
    }

    @Override
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        String username = (String)principals.fromRealm(this.getName()).iterator().next();
        if (username == null || StringUtils.isBlank(username)) {
            return null;
        }
        try {
            return this.getSimpleAuthorizationInfo(username);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        DefaultResult<AccountVO> result;
        AccountVO accountObj;
        block4: {
            GreenStepBaseUsernamePasswordToken token = (GreenStepBaseUsernamePasswordToken)authenticationToken;
            String account = token.getUsername();
            accountObj = new AccountVO();
            accountObj.setAccount(account);
            result = this.accountService.findByUK(accountObj);
            if (result.getValue() != null) break block4;
            return null;
        }
        try {
            accountObj = result.getValue();
            return new SimpleAuthenticationInfo(accountObj.getAccount(), (Object)accountObj.getPassword(), this.getName());
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

