/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.sys;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.env.IniWebEnvironment;

public class BackgroundProgramUserUtils {
    private static IniWebEnvironment environment;
    private static SecurityManager securityManager;
    private static ThreadLocal<Subject> subjectThreadLocal;

    static {
        subjectThreadLocal = new ThreadLocal();
        environment = new IniWebEnvironment();
        environment.setConfigLocations("classpath:shiro.ini");
        environment.init();
        securityManager = environment.getSecurityManager();
    }

    public static boolean isLogin() {
        if (subjectThreadLocal.get() != null) {
            return subjectThreadLocal.get().isAuthenticated();
        }
        return false;
    }

    public static Subject getSubject() {
        return subjectThreadLocal.get();
    }

    public static void logout() throws Exception {
        if (BackgroundProgramUserUtils.getSubject() != null) {
            BackgroundProgramUserUtils.getSubject().logout();
        }
        subjectThreadLocal.remove();
    }

    public static void login() throws Exception {
        if (securityManager == null) {
            throw new Exception("Security manager is null!");
        }
        SecurityUtils.setSecurityManager(securityManager);
        Subject subject = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken("system", "password99");
        subject.login(token);
        subjectThreadLocal.set(subject);
    }
}

