/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.support;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.model.ExpressionJobObj;
import com.netsteadfast.greenstep.service.ISysExprJobLogService;
import com.netsteadfast.greenstep.service.ISysExprJobService;
import com.netsteadfast.greenstep.service.ISysMailHelperService;
import com.netsteadfast.greenstep.util.MailClientUtils;
import com.netsteadfast.greenstep.util.ScriptExpressionUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.vo.SysExprJobLogVO;
import com.netsteadfast.greenstep.vo.SysMailHelperVO;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ExpressionJobExecuteCallable
implements Callable<ExpressionJobObj> {
    protected static Logger logger = Logger.getLogger(ExpressionJobExecuteCallable.class);
    private ExpressionJobObj jobObj = null;

    public ExpressionJobExecuteCallable(ExpressionJobObj jobObj) {
        this.jobObj = jobObj;
    }

    public ExpressionJobObj getJobObj() {
        return this.jobObj;
    }

    public void setJobObj(ExpressionJobObj jobObj) {
        this.jobObj = jobObj;
    }

    @Override
    public ExpressionJobObj call() throws Exception {
        Date beginDatetime = new Date();
        String faultMsg = "";
        String runStatus = "";
        String logStatus = "";
        ISysExprJobService sysExprJobService = (ISysExprJobService)AppContext.getBean("core.service.SysExprJobService");
        ISysExprJobLogService sysExprJobLogService = (ISysExprJobLogService)AppContext.getBean("core.service.SysExprJobLogService");
        try {
            logger.info("[Expression-Job] (Start) ID: " + this.jobObj.getSysExprJob().getId() + " , NAME: " + this.jobObj.getSysExprJob().getName());
            if (StringUtils.isBlank(this.jobObj.getSysExpression().getContent())) {
                faultMsg = "No expression content!";
                runStatus = "F";
                logStatus = "N";
                ExpressionJobObj expressionJobObj = this.jobObj;
                return expressionJobObj;
            }
            if ("Y".equals(this.jobObj.getSysExprJob().getCheckFault()) && "F".equals(this.jobObj.getSysExprJob().getRunStatus())) {
                faultMsg = "Before proccess fault, cannot execute expression job!";
                runStatus = "F";
                logStatus = "N";
                ExpressionJobObj expressionJobObj = this.jobObj;
                return expressionJobObj;
            }
            try {
                this.jobObj.getSysExprJob().setRunStatus("R");
                sysExprJobService.updateObject(this.jobObj.getSysExprJob());
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("jobObj", this.jobObj);
                ScriptExpressionUtils.execute(this.jobObj.getSysExpression().getType(), this.jobObj.getSysExpression().getContent(), paramMap, paramMap);
                runStatus = "Y";
                logStatus = "Y";
            }
            catch (ServiceException se) {
                faultMsg = se.getMessage().toString();
                runStatus = "F";
                logStatus = "F";
                logger.error(se.getMessage().toString());
            }
            catch (Exception e) {
                faultMsg = e.getMessage().toString();
                faultMsg = e.getMessage() == null ? e.toString() : e.getMessage().toString();
                runStatus = "F";
                logStatus = "F";
                logger.error(faultMsg);
            }
        }
        finally {
            if (faultMsg.length() > 2000) {
                faultMsg = faultMsg.substring(0, 2000);
            }
            this.jobObj.getSysExprJob().setRunStatus(runStatus);
            this.jobObj.getSysExprJobLog().setFaultMsg(faultMsg);
            this.jobObj.getSysExprJobLog().setLogStatus(logStatus);
            this.jobObj.getSysExprJobLog().setId(this.jobObj.getSysExprJob().getId());
            this.jobObj.getSysExprJobLog().setBeginDatetime(beginDatetime);
            this.jobObj.getSysExprJobLog().setEndDatetime(new Date());
            sysExprJobService.updateObject(this.jobObj.getSysExprJob());
            DefaultResult<SysExprJobLogVO> jobLogResult = sysExprJobLogService.saveObject(this.jobObj.getSysExprJobLog());
            if (jobLogResult.getValue() != null) {
                this.jobObj.setSysExprJobLog(jobLogResult.getValue());
            }
            this.sendMail();
            logger.info("[Expression-Job] (End) ID: " + this.jobObj.getSysExprJob().getId() + " , NAME: " + this.jobObj.getSysExprJob().getName());
        }
        return this.jobObj;
    }

    private void sendMail() {
        try {
            if ("0".equals(this.jobObj.getSysExprJob().getContactMode())) {
                return;
            }
            if ("1".equals(this.jobObj.getSysExprJob().getContactMode()) && !"F".equals(this.jobObj.getSysExprJob().getRunStatus())) {
                return;
            }
            if ("2".equals(this.jobObj.getSysExprJob().getContactMode()) && !"Y".equals(this.jobObj.getSysExprJob().getRunStatus())) {
                return;
            }
            String contact = StringUtils.defaultString(this.jobObj.getSysExprJob().getContact()).trim();
            if (StringUtils.isBlank(contact)) {
                return;
            }
            String subject = String.valueOf(this.jobObj.getSysExprJob().getId()) + " - " + this.jobObj.getSysExprJob().getName();
            String content = String.valueOf(subject) + "<BR/>";
            content = String.valueOf(content) + "Run status: " + this.jobObj.getSysExprJob().getRunStatus() + "<BR/>";
            content = String.valueOf(content) + "Start: " + this.jobObj.getSysExprJobLog().getBeginDatetime().toString() + "<BR/>";
            content = String.valueOf(content) + "End: " + this.jobObj.getSysExprJobLog().getEndDatetime().toString() + "<BR/>";
            if ("F".equals(this.jobObj.getSysExprJob().getRunStatus())) {
                content = String.valueOf(content) + "<BR/>";
                content = String.valueOf(content) + "Fault: <BR/>";
                content = String.valueOf(content) + this.jobObj.getSysExprJobLog().getFaultMsg();
            }
            ISysMailHelperService sysMailHelperService = (ISysMailHelperService)AppContext.getBean("core.service.SysMailHelperService");
            String mailId = SimpleUtils.getStrYMD("");
            SysMailHelperVO mailHelper = new SysMailHelperVO();
            mailHelper.setMailId(sysMailHelperService.findForMaxMailIdComplete(mailId));
            mailHelper.setMailFrom(MailClientUtils.getDefaultFrom());
            mailHelper.setMailTo(contact);
            mailHelper.setSubject(subject);
            mailHelper.setText(content.getBytes("utf8"));
            mailHelper.setRetainFlag("N");
            mailHelper.setSuccessFlag("N");
            sysMailHelperService.saveObject(mailHelper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

