/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.service.logic.BaseLogicService;
import com.netsteadfast.greenstep.model.TemplateCode;
import com.netsteadfast.greenstep.po.hbm.TbSysTemplate;
import com.netsteadfast.greenstep.po.hbm.TbSysTemplateParam;
import com.netsteadfast.greenstep.service.ISysTemplateParamService;
import com.netsteadfast.greenstep.service.ISysTemplateService;
import com.netsteadfast.greenstep.service.logic.ISystemTemplateLogicService;
import com.netsteadfast.greenstep.vo.SysTemplateParamVO;
import com.netsteadfast.greenstep.vo.SysTemplateVO;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="core.service.logic.SystemTemplateLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class SystemTemplateLogicServiceImpl
extends BaseLogicService
implements ISystemTemplateLogicService {
    protected Logger logger = Logger.getLogger(SystemTemplateLogicServiceImpl.class);
    private static final int MAX_MESSAGE_LENGTH = 4000;
    private ISysTemplateService<SysTemplateVO, TbSysTemplate, String> sysTemplateService;
    private ISysTemplateParamService<SysTemplateParamVO, TbSysTemplateParam, String> sysTemplateParamService;

    public ISysTemplateService<SysTemplateVO, TbSysTemplate, String> getSysTemplateService() {
        return this.sysTemplateService;
    }

    @Autowired
    @Resource(name="core.service.SysTemplateService")
    @Required
    public void setSysTemplateService(ISysTemplateService<SysTemplateVO, TbSysTemplate, String> sysTemplateService) {
        this.sysTemplateService = sysTemplateService;
    }

    public ISysTemplateParamService<SysTemplateParamVO, TbSysTemplateParam, String> getSysTemplateParamService() {
        return this.sysTemplateParamService;
    }

    @Autowired
    @Resource(name="core.service.SysTemplateParamService")
    @Required
    public void setSysTemplateParamService(ISysTemplateParamService<SysTemplateParamVO, TbSysTemplateParam, String> sysTemplateParamService) {
        this.sysTemplateParamService = sysTemplateParamService;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysTemplateVO> create(SysTemplateVO sysTemplate) throws ServiceException, Exception {
        if (sysTemplate == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        if (super.defaultString(sysTemplate.getMessage()).length() > 4000) {
            throw new ServiceException("Content max only 4,000 words!");
        }
        return this.sysTemplateService.saveObject(sysTemplate);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysTemplateVO> update(SysTemplateVO sysTemplate) throws ServiceException, Exception {
        if (sysTemplate == null || super.isBlank(sysTemplate.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        if (super.defaultString(sysTemplate.getMessage()).length() > 4000) {
            throw new ServiceException("Content max only 4,000 words!");
        }
        DefaultResult<SysTemplateVO> oldResult = this.sysTemplateService.findObjectByOid(sysTemplate);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        sysTemplate.setTemplateId(oldResult.getValue().getTemplateId());
        return this.sysTemplateService.updateObject(sysTemplate);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> delete(SysTemplateVO sysTemplate) throws ServiceException, Exception {
        if (sysTemplate == null || super.isBlank(sysTemplate.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<SysTemplateVO> oldResult = this.sysTemplateService.findObjectByOid(sysTemplate);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        sysTemplate = oldResult.getValue();
        if (TemplateCode.isUsed(sysTemplate.getTemplateId())) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("templateId", sysTemplate.getTemplateId());
        List templateParamList = this.sysTemplateParamService.findListByParams(params);
        int i = 0;
        while (templateParamList != null && i < templateParamList.size()) {
            this.sysTemplateParamService.delete((TbSysTemplateParam)templateParamList.get(i));
            ++i;
        }
        return this.sysTemplateService.deleteObject(sysTemplate);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysTemplateParamVO> createParam(SysTemplateParamVO sysTemplateParam, String templateOid) throws ServiceException, Exception {
        if (sysTemplateParam == null || super.isBlank(templateOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysTemplateVO sysTemplate = new SysTemplateVO();
        sysTemplate.setOid(templateOid);
        DefaultResult<SysTemplateVO> mResult = this.sysTemplateService.findObjectByOid(sysTemplate);
        if (mResult.getValue() == null) {
            throw new ServiceException(mResult.getSystemMessage().getValue());
        }
        sysTemplate = mResult.getValue();
        sysTemplateParam.setTemplateId(sysTemplate.getTemplateId());
        return this.sysTemplateParamService.saveObject(sysTemplateParam);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> deleteParam(SysTemplateParamVO sysTemplateParam) throws ServiceException, Exception {
        if (sysTemplateParam == null || super.isBlank(sysTemplateParam.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.sysTemplateParamService.deleteObject(sysTemplateParam);
    }
}

