/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.service.logic.BaseLogicService;
import com.netsteadfast.greenstep.po.hbm.TbAccount;
import com.netsteadfast.greenstep.po.hbm.TbSys;
import com.netsteadfast.greenstep.po.hbm.TbSysMsgNotice;
import com.netsteadfast.greenstep.po.hbm.TbSysMsgNoticeConfig;
import com.netsteadfast.greenstep.service.IAccountService;
import com.netsteadfast.greenstep.service.ISysMsgNoticeConfigService;
import com.netsteadfast.greenstep.service.ISysMsgNoticeService;
import com.netsteadfast.greenstep.service.ISysService;
import com.netsteadfast.greenstep.service.logic.ISystemMessageNoticeLogicService;
import com.netsteadfast.greenstep.vo.AccountVO;
import com.netsteadfast.greenstep.vo.SysMsgNoticeConfigVO;
import com.netsteadfast.greenstep.vo.SysMsgNoticeVO;
import com.netsteadfast.greenstep.vo.SysVO;
import java.io.IOException;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="core.service.logic.SystemMessageNoticeLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class SystemMessageNoticeLogicServiceImpl
extends BaseLogicService
implements ISystemMessageNoticeLogicService {
    protected Logger logger = Logger.getLogger(SystemMessageNoticeLogicServiceImpl.class);
    private static final int MAX_MESSAGE_LENGTH = 1000;
    private ISysService<SysVO, TbSys, String> sysService;
    private ISysMsgNoticeService<SysMsgNoticeVO, TbSysMsgNotice, String> sysMsgNoticeService;
    private ISysMsgNoticeConfigService<SysMsgNoticeConfigVO, TbSysMsgNoticeConfig, String> sysMsgNoticeConfigService;
    private IAccountService<AccountVO, TbAccount, String> accountService;

    public ISysService<SysVO, TbSys, String> getSysService() {
        return this.sysService;
    }

    @Autowired
    @Resource(name="core.service.SysService")
    @Required
    public void setSysService(ISysService<SysVO, TbSys, String> sysService) {
        this.sysService = sysService;
    }

    public ISysMsgNoticeService<SysMsgNoticeVO, TbSysMsgNotice, String> getSysMsgNoticeService() {
        return this.sysMsgNoticeService;
    }

    @Autowired
    @Resource(name="core.service.SysMsgNoticeService")
    @Required
    public void setSysMsgNoticeService(ISysMsgNoticeService<SysMsgNoticeVO, TbSysMsgNotice, String> sysMsgNoticeService) {
        this.sysMsgNoticeService = sysMsgNoticeService;
    }

    public ISysMsgNoticeConfigService<SysMsgNoticeConfigVO, TbSysMsgNoticeConfig, String> getSysMsgNoticeConfigService() {
        return this.sysMsgNoticeConfigService;
    }

    @Autowired
    @Resource(name="core.service.SysMsgNoticeConfigService")
    @Required
    public void setSysMsgNoticeConfigService(ISysMsgNoticeConfigService<SysMsgNoticeConfigVO, TbSysMsgNoticeConfig, String> sysMsgNoticeConfigService) {
        this.sysMsgNoticeConfigService = sysMsgNoticeConfigService;
    }

    public IAccountService<AccountVO, TbAccount, String> getAccountService() {
        return this.accountService;
    }

    @Autowired
    @Resource(name="core.service.AccountService")
    @Required
    public void setAccountService(IAccountService<AccountVO, TbAccount, String> accountService) {
        this.accountService = accountService;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysMsgNoticeConfigVO> createConfig(SysMsgNoticeConfigVO config, String systemOid) throws ServiceException, Exception {
        if (super.isBlank(systemOid) || config == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysVO sys = new SysVO();
        sys.setOid(systemOid);
        DefaultResult<SysVO> sysResult = this.sysService.findObjectByOid(sys);
        if (sysResult.getValue() == null) {
            throw new ServiceException(sysResult.getSystemMessage().getValue());
        }
        sys = sysResult.getValue();
        config.setSystem(sys.getSysId());
        return this.sysMsgNoticeConfigService.saveObject(config);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysMsgNoticeConfigVO> updateConfig(SysMsgNoticeConfigVO config, String systemOid) throws ServiceException, Exception {
        if (config == null || super.isBlank(config.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysVO sys = new SysVO();
        sys.setOid(systemOid);
        DefaultResult<SysVO> sysResult = this.sysService.findObjectByOid(sys);
        if (sysResult.getValue() == null) {
            throw new ServiceException(sysResult.getSystemMessage().getValue());
        }
        sys = sysResult.getValue();
        DefaultResult<SysMsgNoticeConfigVO> oldResult = this.sysMsgNoticeConfigService.findObjectByOid(config);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        config.setMsgId(oldResult.getValue().getMsgId());
        config.setSystem(sys.getSysId());
        return this.sysMsgNoticeConfigService.updateObject(config);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> deleteConfig(SysMsgNoticeConfigVO config) throws ServiceException, Exception {
        if (config == null || super.isBlank(config.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<SysMsgNoticeConfigVO> oldResult = this.sysMsgNoticeConfigService.findObjectByOid(config);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("msgId", oldResult.getValue().getMsgId());
        if (this.sysMsgNoticeService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        return this.sysMsgNoticeConfigService.deleteObject(config);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysMsgNoticeVO> create(SysMsgNoticeVO notice, String configOid, String accountOid) throws ServiceException, Exception {
        if (super.isBlank(configOid) || notice == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysMsgNoticeConfigVO config = new SysMsgNoticeConfigVO();
        config.setOid(configOid);
        DefaultResult<SysMsgNoticeConfigVO> configResult = this.sysMsgNoticeConfigService.findObjectByOid(config);
        if (configResult.getValue() == null) {
            throw new ServiceException(configResult.getSystemMessage().getValue());
        }
        config = configResult.getValue();
        notice.setMsgId(config.getMsgId());
        notice.setToAccount("*");
        if (!super.isNoSelectId(accountOid) && !"*".equals(accountOid)) {
            AccountVO account = new AccountVO();
            account.setOid(accountOid);
            DefaultResult<AccountVO> aResult = this.accountService.findObjectByOid(account);
            if (aResult.getValue() == null) {
                throw new ServiceException(aResult.getSystemMessage().getValue());
            }
            account = aResult.getValue();
            notice.setToAccount(account.getAccount());
        }
        if (super.defaultString(notice.getMessage()).length() > 1000) {
            notice.setMessage(notice.getMessage().substring(0, 1000));
        }
        return this.sysMsgNoticeService.saveObject(notice);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysMsgNoticeVO> update(SysMsgNoticeVO notice, String accountOid) throws ServiceException, Exception {
        if (notice == null || super.isBlank(notice.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<SysMsgNoticeVO> oldResult = this.sysMsgNoticeService.findObjectByOid(notice);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        notice.setNoticeId(oldResult.getValue().getNoticeId());
        notice.setMsgId(oldResult.getValue().getMsgId());
        notice.setToAccount("*");
        if (!super.isNoSelectId(accountOid) && !"*".equals(accountOid)) {
            AccountVO account = new AccountVO();
            account.setOid(accountOid);
            DefaultResult<AccountVO> aResult = this.accountService.findObjectByOid(account);
            if (aResult.getValue() == null) {
                throw new ServiceException(aResult.getSystemMessage().getValue());
            }
            account = aResult.getValue();
            notice.setToAccount(account.getAccount());
        }
        if (super.defaultString(notice.getMessage()).length() > 1000) {
            notice.setMessage(notice.getMessage().substring(0, 1000));
        }
        return this.sysMsgNoticeService.updateObject(notice);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> delete(SysMsgNoticeVO notice) throws ServiceException, Exception {
        if (notice == null || super.isBlank(notice.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.sysMsgNoticeService.deleteObject(notice);
    }
}

