/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.service.logic.BaseLogicService;
import com.netsteadfast.greenstep.model.TemplateResultObj;
import com.netsteadfast.greenstep.po.hbm.TbAccount;
import com.netsteadfast.greenstep.po.hbm.TbSysCalendarNote;
import com.netsteadfast.greenstep.po.hbm.TbSysMailHelper;
import com.netsteadfast.greenstep.service.IAccountService;
import com.netsteadfast.greenstep.service.ISysCalendarNoteService;
import com.netsteadfast.greenstep.service.ISysMailHelperService;
import com.netsteadfast.greenstep.service.logic.ISystemCalendarNoteLogicService;
import com.netsteadfast.greenstep.util.MailClientUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.util.TemplateUtils;
import com.netsteadfast.greenstep.vo.AccountVO;
import com.netsteadfast.greenstep.vo.SysCalendarNoteVO;
import com.netsteadfast.greenstep.vo.SysMailHelperVO;
import java.io.IOException;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="core.service.logic.SystemCalendarNoteLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class SystemCalendarNoteLogicServiceImpl
extends BaseLogicService
implements ISystemCalendarNoteLogicService {
    protected Logger logger = Logger.getLogger(SystemCalendarNoteLogicServiceImpl.class);
    private static final int MAX_NOTE_LENGTH = 1000;
    private IAccountService<AccountVO, TbAccount, String> accountService;
    private ISysCalendarNoteService<SysCalendarNoteVO, TbSysCalendarNote, String> sysCalendarNoteService;
    private ISysMailHelperService<SysMailHelperVO, TbSysMailHelper, String> sysMailHelperService;

    public IAccountService<AccountVO, TbAccount, String> getAccountService() {
        return this.accountService;
    }

    @Autowired
    @Resource(name="core.service.AccountService")
    @Required
    public void setAccountService(IAccountService<AccountVO, TbAccount, String> accountService) {
        this.accountService = accountService;
    }

    public ISysCalendarNoteService<SysCalendarNoteVO, TbSysCalendarNote, String> getSysCalendarNoteService() {
        return this.sysCalendarNoteService;
    }

    @Autowired
    @Resource(name="core.service.SysCalendarNoteService")
    @Required
    public void setSysCalendarNoteService(ISysCalendarNoteService<SysCalendarNoteVO, TbSysCalendarNote, String> sysCalendarNoteService) {
        this.sysCalendarNoteService = sysCalendarNoteService;
    }

    public ISysMailHelperService<SysMailHelperVO, TbSysMailHelper, String> getSysMailHelperService() {
        return this.sysMailHelperService;
    }

    @Autowired
    @Resource(name="core.service.SysMailHelperService")
    @Required
    public void setSysMailHelperService(ISysMailHelperService<SysMailHelperVO, TbSysMailHelper, String> sysMailHelperService) {
        this.sysMailHelperService = sysMailHelperService;
    }

    private void createMailHelper(SysCalendarNoteVO note) {
        if (note == null || super.isBlank(note.getOid())) {
            return;
        }
        if (!"Y".equals(note.getAlert())) {
            return;
        }
        if (super.isBlank(note.getContact())) {
            return;
        }
        String[] receiveMail = note.getContact().trim().split(";");
        String mailId = SimpleUtils.getStrYMD("");
        String[] stringArray = receiveMail;
        int n = receiveMail.length;
        int n2 = 0;
        while (n2 < n) {
            String toMail = stringArray[n2];
            try {
                TemplateResultObj result = TemplateUtils.getResult("TPLMSG0001", note);
                String content = result.getContent();
                if (StringUtils.isBlank(content)) {
                    content = note.getNote();
                }
                SysMailHelperVO mailHelper = new SysMailHelperVO();
                mailHelper.setMailId(this.sysMailHelperService.findForMaxMailIdComplete(mailId));
                mailHelper.setMailFrom(MailClientUtils.getDefaultFrom());
                mailHelper.setMailTo(toMail);
                mailHelper.setSubject(note.getTitle());
                mailHelper.setText(content.getBytes("utf8"));
                mailHelper.setRetainFlag("N");
                mailHelper.setSuccessFlag("N");
                this.sysMailHelperService.saveObject(mailHelper);
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysCalendarNoteVO> create(SysCalendarNoteVO sysCalendarNote, String accountOid) throws ServiceException, Exception {
        if (super.isBlank(accountOid) || sysCalendarNote == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        AccountVO account = new AccountVO();
        account.setOid(accountOid);
        DefaultResult<AccountVO> aResult = this.accountService.findObjectByOid(account);
        if (aResult.getValue() == null) {
            throw new ServiceException(aResult.getSystemMessage().getValue());
        }
        account = aResult.getValue();
        sysCalendarNote.setDate(sysCalendarNote.getDate().replaceAll("/", "").replaceAll("-", ""));
        sysCalendarNote.setAccount(account.getAccount());
        String canendarId = this.sysCalendarNoteService.findForMaxCalendarId(account.getAccount(), sysCalendarNote.getDate());
        if (StringUtils.isBlank(canendarId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
        }
        sysCalendarNote.setCalendarId(canendarId);
        if (super.defaultString(sysCalendarNote.getNote()).length() > 1000) {
            sysCalendarNote.setNote(sysCalendarNote.getNote().substring(0, 1000));
        }
        DefaultResult<SysCalendarNoteVO> result = this.sysCalendarNoteService.saveObject(sysCalendarNote);
        this.createMailHelper(result.getValue());
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysCalendarNoteVO> update(SysCalendarNoteVO sysCalendarNote) throws ServiceException, Exception {
        if (sysCalendarNote == null || super.isBlank(sysCalendarNote.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<SysCalendarNoteVO> oldResult = this.sysCalendarNoteService.findObjectByOid(sysCalendarNote);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        sysCalendarNote.setAccount(oldResult.getValue().getAccount());
        sysCalendarNote.setCalendarId(oldResult.getValue().getCalendarId());
        sysCalendarNote.setDate(sysCalendarNote.getDate().replaceAll("/", "").replaceAll("-", ""));
        if (super.defaultString(sysCalendarNote.getNote()).length() > 1000) {
            sysCalendarNote.setNote(sysCalendarNote.getNote().substring(0, 1000));
        }
        DefaultResult<SysCalendarNoteVO> result = this.sysCalendarNoteService.updateObject(sysCalendarNote);
        this.createMailHelper(result.getValue());
        return result;
    }
}

