/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.service.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.dao.IBaseDAO;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.PageOf;
import com.netsteadfast.greenstep.base.model.QueryResult;
import com.netsteadfast.greenstep.base.model.SearchValue;
import com.netsteadfast.greenstep.base.service.BaseService;
import com.netsteadfast.greenstep.dao.ISysCalendarNoteDAO;
import com.netsteadfast.greenstep.po.hbm.TbSysCalendarNote;
import com.netsteadfast.greenstep.service.ISysCalendarNoteService;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.vo.SysCalendarNoteVO;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="core.service.SysCalendarNoteService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class SysCalendarNoteServiceImpl
extends BaseService<SysCalendarNoteVO, TbSysCalendarNote, String>
implements ISysCalendarNoteService<SysCalendarNoteVO, TbSysCalendarNote, String> {
    protected Logger logger = Logger.getLogger(SysCalendarNoteServiceImpl.class);
    private ISysCalendarNoteDAO<TbSysCalendarNote, String> sysCalendarNoteDAO;

    public ISysCalendarNoteDAO<TbSysCalendarNote, String> getSysCalendarNoteDAO() {
        return this.sysCalendarNoteDAO;
    }

    @Autowired
    @Resource(name="core.dao.SysCalendarNoteDAO")
    @Required
    public void setSysCalendarNoteDAO(ISysCalendarNoteDAO<TbSysCalendarNote, String> sysCalendarNoteDAO) {
        this.sysCalendarNoteDAO = sysCalendarNoteDAO;
    }

    @Override
    protected IBaseDAO<TbSysCalendarNote, String> getBaseDataAccessObject() {
        return this.sysCalendarNoteDAO;
    }

    @Override
    public String getMapperIdPo2Vo() {
        return "sysCalendarNote.po2vo";
    }

    @Override
    public String getMapperIdVo2Po() {
        return "sysCalendarNote.vo2po";
    }

    private Map<String, Object> getQueryGridParameter(SearchValue searchValue) throws Exception {
        String date = searchValue.getParameter().get("date");
        Map<String, Object> params = super.getQueryParamHandler(searchValue).fullEquals4Select("accountOid").getValue();
        if (!StringUtils.isBlank(date) && SimpleUtils.isDate(date)) {
            params.put("date", date.replaceAll("-", "").replaceAll("/", ""));
        }
        return params;
    }

    @Override
    public QueryResult<List<SysCalendarNoteVO>> findGridResult(SearchValue searchValue, PageOf pageOf) throws ServiceException, Exception {
        if (searchValue == null || pageOf == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0009"));
        }
        Map<String, Object> params = this.getQueryGridParameter(searchValue);
        int limit = Integer.parseInt(pageOf.getShowRow());
        int offset = (Integer.parseInt(pageOf.getSelect()) - 1) * limit;
        QueryResult<List<SysCalendarNoteVO>> result = this.sysCalendarNoteDAO.findPageQueryResultByQueryName("findSysCalendarNote", params, offset, limit);
        pageOf.setCountSize(String.valueOf(result.getRowCount()));
        pageOf.toCalculateSize();
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public String findForMaxCalendarId(String account, String date) throws ServiceException, Exception {
        if (StringUtils.isBlank(account) || StringUtils.isBlank(date)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        String calendarId = this.sysCalendarNoteDAO.findForMaxCalendarId(account, date);
        if (!StringUtils.isBlank(calendarId)) {
            int num = Integer.parseInt(calendarId.substring(8, 11)) + 1;
            if (num > 999) {
                throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
            }
            return String.valueOf(date) + StringUtils.leftPad(String.valueOf(num), 3, "0");
        }
        return String.valueOf(date) + "001";
    }
}

