/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.job;

import com.netsteadfast.greenstep.sys.BackgroundProgramUserUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobExecutionContext;
import org.quartz.SchedulerException;
import org.springframework.scheduling.quartz.QuartzJobBean;

public abstract class BaseJob
extends QuartzJobBean {
    protected boolean checkCurrentlyExecutingJobs(JobExecutionContext context, QuartzJobBean currentJob) {
        boolean beofreJobWork = false;
        try {
            List<JobExecutionContext> jobs = context.getScheduler().getCurrentlyExecutingJobs();
            int j = 0;
            while (jobs != null && !jobs.isEmpty() && j < jobs.size() && !beofreJobWork) {
                JobExecutionContext job = jobs.get(j);
                if (job.getTrigger().equals(context.getTrigger()) && !job.getJobInstance().equals(currentJob)) {
                    beofreJobWork = true;
                }
                ++j;
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        return beofreJobWork;
    }

    public String getAccountId() {
        return StringUtils.defaultString((String)BackgroundProgramUserUtils.getSubject().getPrincipal());
    }

    public String generateOid() {
        return SimpleUtils.getUUIDStr();
    }

    public void loginForBackgroundProgram() throws Exception {
        BackgroundProgramUserUtils.login();
    }

    public void logoutForBackgroundProgram() throws Exception {
        BackgroundProgramUserUtils.logout();
    }
}

