/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.dao.impl;

import com.netsteadfast.greenstep.base.dao.BaseDAO;
import com.netsteadfast.greenstep.dao.ISysMenuDAO;
import com.netsteadfast.greenstep.po.hbm.TbSysMenu;
import com.netsteadfast.greenstep.vo.SysMenuVO;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository(value="core.dao.SysMenuDAO")
public class SysMenuDAOImpl
extends BaseDAO<TbSysMenu, String>
implements ISysMenuDAO<TbSysMenu, String> {
    @Override
    public List<SysMenuVO> findForMenuGenerator(String progSystem, String account) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT\tnew com.netsteadfast.greenstep.vo.SysMenuVO(\t");
        sb.append("\t\tsm.oid, sm.progId, sm.parentOid, sm.enableFlag,\t");
        sb.append("\t\ttsp.name, tsp.url, tsp.progSystem, tsp.itemType, tsp.icon\t");
        sb.append(")\t");
        sb.append("FROM\t");
        sb.append("TbSysMenu sm, TbSysProg tsp\t");
        sb.append("WHERE sm.progId=tsp.progId\tAND\ttsp.progSystem = :progSystem\t");
        if (!StringUtils.isBlank(account)) {
            sb.append("AND sm.progId IN (\t");
            sb.append("\tSELECT progId FROM TbSysMenuRole where role IN (\t");
            sb.append("\t\tSELECT role FROM TbUserRole WHERE account = :account ");
            sb.append("\t)\t");
            sb.append(")\t");
        }
        sb.append("ORDER BY tsp.progId, tsp.name ASC\t");
        Query query = this.getCurrentSession().createQuery(sb.toString());
        query.setString("progSystem", progSystem);
        if (!StringUtils.isBlank(account)) {
            query.setString("account", account);
        }
        return query.list();
    }
}

