/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.service.logic;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.service.logic.CoreBaseLogicService;
import com.netsteadfast.greenstep.base.service.logic.IBusinessProcessManagementResourcePlusProvide;
import com.netsteadfast.greenstep.base.service.logic.IBusinessProcessManagementResourceProvide;
import com.netsteadfast.greenstep.po.hbm.TbUserRole;
import com.netsteadfast.greenstep.util.BusinessProcessManagementUtils;
import com.netsteadfast.greenstep.vo.BusinessProcessManagementTaskVO;
import com.netsteadfast.greenstep.vo.SysBpmnResourceVO;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.activiti.engine.task.Task;

public abstract class BusinessProcessManagementBaseLogicService
extends CoreBaseLogicService
implements IBusinessProcessManagementResourceProvide<SysBpmnResourceVO, Task>,
IBusinessProcessManagementResourcePlusProvide {
    @Override
    public abstract String getBusinessProcessManagementResourceId();

    @Override
    public SysBpmnResourceVO getBusinessProcessManagementResourceObject() throws ServiceException, Exception {
        return BusinessProcessManagementUtils.loadResource(this.getBusinessProcessManagementResourceId());
    }

    @Override
    public String startProcess(Map<String, Object> paramMap) throws Exception {
        return BusinessProcessManagementUtils.startProcess(this.getBusinessProcessManagementResourceId(), paramMap);
    }

    @Override
    public void completeTask(String taskId, Map<String, Object> paramMap) throws Exception {
        BusinessProcessManagementUtils.completeTask(taskId, paramMap);
    }

    @Override
    public List<Task> queryTask() throws Exception {
        return BusinessProcessManagementUtils.queryTask(this.getBusinessProcessManagementResourceId());
    }

    @Override
    public List<BusinessProcessManagementTaskVO> queryTaskPlus() throws ServiceException, Exception {
        return this.queryTaskPlus(null, null);
    }

    @Override
    public List<BusinessProcessManagementTaskVO> queryTaskPlus(String variableKeyName, String variableKeyValue) throws ServiceException, Exception {
        List<Task> queryTask = null;
        queryTask = !super.isBlank(variableKeyValue) && !super.isBlank(variableKeyValue) ? this.queryTaskByVariable(variableKeyName, variableKeyValue) : this.queryTask();
        LinkedList<BusinessProcessManagementTaskVO> tasks = new LinkedList<BusinessProcessManagementTaskVO>();
        int i = 0;
        while (queryTask != null && i < queryTask.size()) {
            Task task;
            BusinessProcessManagementTaskVO bpmTaskObj = new BusinessProcessManagementTaskVO(task, this.isRoleAllowApproval((task = queryTask.get(i)).getName()) ? "Y" : "N", BusinessProcessManagementUtils.getTaskVariables(task));
            tasks.add(bpmTaskObj);
            ++i;
        }
        return tasks;
    }

    public boolean isRoleAllowApproval(String taskName) throws ServiceException, Exception {
        return this.isRoleAllowApproval(super.getAccountId(), taskName);
    }

    public boolean isRoleAllowApproval(String accountId, String taskName) throws ServiceException, Exception {
        if (super.isBlank(accountId) || super.isBlank(taskName)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        List<TbUserRole> roles = this.findUserRoles(accountId);
        if (roles == null || roles.size() < 1) {
            return false;
        }
        boolean allow = false;
        int i = 0;
        while (i < roles.size() && !allow) {
            if (BusinessProcessManagementUtils.isRoleAllowApproval(this.getBusinessProcessManagementResourceId(), roles.get(i).getRole(), taskName)) {
                allow = true;
                i = roles.size();
            }
            ++i;
        }
        return allow;
    }

    public List<Task> queryTaskByVariable(String variableKeyName, String variableKeyValue) throws ServiceException, Exception {
        if (super.isBlank(variableKeyName) || super.isBlank(variableKeyValue)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        ArrayList<Task> tasks = new ArrayList<Task>();
        List<Task> queryTasks = this.queryTask();
        if (queryTasks == null || queryTasks.size() < 1) {
            return tasks;
        }
        for (Task task : queryTasks) {
            Map<String, Object> variables = BusinessProcessManagementUtils.getTaskVariables(task);
            if (variables == null || super.isBlank((String)variables.get(variableKeyName)) || !variableKeyValue.equals(variables.get(variableKeyName))) continue;
            tasks.add(task);
        }
        return tasks;
    }
}

