/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.interceptor;

import com.netsteadfast.greenstep.base.model.AccountObj;
import com.netsteadfast.greenstep.base.sys.UserAccountHttpSessionSupport;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.io.PrintWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="greenstep.web.interceptor.UserLoginMobileInterceptor")
@Scope(value="prototype")
public class UserLoginMobileInterceptor
extends AbstractInterceptor {
    protected static Logger logger = Logger.getLogger(UserLoginMobileInterceptor.class);
    private static final long serialVersionUID = -7712139684710943707L;

    @Override
    public String intercept(ActionInvocation actionInvocation) throws Exception {
        AccountObj accountObj = UserAccountHttpSessionSupport.get(ServletActionContext.getRequest());
        String accountId = accountObj.getAccount();
        if (SecurityUtils.getSubject().isAuthenticated() && !StringUtils.isBlank(accountId)) {
            return actionInvocation.invoke();
        }
        String header = ServletActionContext.getRequest().getHeader("X-Requested-With");
        if ("XMLHttpRequest".equalsIgnoreCase(header)) {
            PrintWriter printWriter = ServletActionContext.getResponse().getWriter();
            printWriter.print("{ \"success\":\"N\",\"message\":\"Please login!\",\"login\":\"N\",\"isAuthorize\":\"N\" }");
            printWriter.flush();
            printWriter.close();
            return null;
        }
        return "logout";
    }
}

